/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.aliyun.ons.impl;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.aliyun.ons.impl.MessageUtil;
import org.noear.solon.cloud.extend.aliyun.ons.impl.OnsConfig;
import org.noear.solon.cloud.model.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnsProducer
implements Closeable {
    static Logger log = LoggerFactory.getLogger(OnsProducer.class);
    private OnsConfig config;
    private Producer producer;

    public OnsProducer(OnsConfig config) {
        this.config = config;
    }

    private void init() {
        if (this.producer != null) {
            return;
        }
        Utils.locker().lock();
        try {
            if (this.producer != null) {
                return;
            }
            this.producer = ONSFactory.createProducer((Properties)this.config.getProducerProperties());
            this.producer.start();
            log.debug("Ons producer started: " + this.producer.isStarted());
        }
        finally {
            Utils.locker().unlock();
        }
    }

    public boolean publish(Event event, String topic) {
        this.init();
        Message message = MessageUtil.buildNewMessage(event, topic);
        SendResult sendReceipt = this.producer.send(message);
        return sendReceipt != null;
    }

    @Override
    public void close() throws IOException {
    }
}

