/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.aliyun.ons.service;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.aliyun.ons.impl.OnsConfig;
import org.noear.solon.cloud.extend.aliyun.ons.impl.OnsConsumer;
import org.noear.solon.cloud.extend.aliyun.ons.impl.OnsProducer;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventTran;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.core.bean.LifecycleBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventServiceOnsImpl
implements CloudEventServicePlus,
LifecycleBean {
    private static final Logger log = LoggerFactory.getLogger(CloudEventServiceOnsImpl.class);
    private CloudProps cloudProps;
    private OnsProducer producer;
    private OnsConsumer consumer;
    CloudEventObserverManger observerManger = new CloudEventObserverManger();
    private String channel;
    private String group;

    public CloudEventServiceOnsImpl(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        OnsConfig config = new OnsConfig(cloudProps);
        this.producer = new OnsProducer(config);
        this.consumer = new OnsConsumer(config);
    }

    private void beginTransaction(EventTran transaction) throws CloudEventException {
        log.warn("Event transactions are not supported!");
    }

    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        if (Utils.isEmpty((String)event.key())) {
            event.key(Utils.guid());
        }
        if (event.tran() != null) {
            this.beginTransaction(event.tran());
        }
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + "--" + event.topic();
        topicNew = topicNew.replace(".", "_");
        try {
            return this.producer.publish(event, topicNew);
        }
        catch (Throwable ex) {
            throw new CloudEventException(ex);
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, String tag, int qos, CloudEventHandler observer) {
        topic = topic.replace(".", "_");
        String topicNew = Utils.isEmpty((String)group) ? topic : group + "--" + topic;
        if (Utils.isEmpty((String)tag)) {
            tag = "*";
        }
        this.observerManger.add(topicNew, level, group, topic, tag, qos, observer);
    }

    public void postStart() throws Throwable {
        this.subscribe();
    }

    private void subscribe() {
        if (this.observerManger.topicSize() > 0) {
            this.consumer.init(this.observerManger);
        }
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = this.cloudProps.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.cloudProps.getEventGroup();
        }
        return this.group;
    }
}

