/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.aws.s3.service;

import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.extend.aws.s3.utils.BucketUtils;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.core.handle.Result;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;

public class CloudFileServiceOfS3SdkImpl
implements CloudFileService {
    private final String bucketDef;
    private final S3Client client;
    private final S3Presigner presigner;

    public S3Client getClient() {
        return this.client;
    }

    public S3Presigner getPresigner() {
        return this.presigner;
    }

    public CloudFileServiceOfS3SdkImpl(CloudProps cloudProps) {
        this.bucketDef = cloudProps.getFileBucket();
        this.client = BucketUtils.createClient(cloudProps);
        this.presigner = BucketUtils.createClientPresigner(cloudProps);
    }

    public CloudFileServiceOfS3SdkImpl(String bucketDef, S3Client client, S3Presigner presigner) {
        this.bucketDef = bucketDef;
        this.client = client;
        this.presigner = presigner;
    }

    public boolean exists(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(key).build();
            return this.client.headObject(headObjectRequest).sdkHttpResponse().isSuccessful();
        }
        catch (NoSuchKeyException e) {
            return false;
        }
        catch (Exception e) {
            throw new CloudFileException((Throwable)e);
        }
    }

    public String getTempUrl(String bucket, String key, Duration duration) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
            GetObjectPresignRequest presignRequest = GetObjectPresignRequest.builder().getObjectRequest(getObjectRequest).signatureDuration(duration).build();
            URL url = this.presigner.presignGetObject(presignRequest).url();
            return url != null ? url.toString() : null;
        }
        catch (Exception e) {
            throw new CloudFileException((Throwable)e);
        }
    }

    public Media get(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
            ResponseInputStream responseInputStream = this.client.getObject(getObjectRequest);
            GetObjectResponse response = (GetObjectResponse)responseInputStream.response();
            String contentType = response.contentType();
            long contentSize = response.contentLength();
            return new Media((InputStream)responseInputStream, contentType, contentSize);
        }
        catch (Exception e) {
            throw new CloudFileException((Throwable)e);
        }
    }

    public Result put(String bucket, String key, Media media) throws CloudFileException {
        String streamMime;
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        if (Utils.isEmpty((String)(streamMime = media.contentType()))) {
            streamMime = "text/plain; charset=utf-8";
        }
        try {
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(key).contentType(streamMime).build();
            RequestBody requestBody = RequestBody.fromInputStream((InputStream)media.body(), (long)media.contentSize());
            PutObjectResponse resp = this.client.putObject(putObjectRequest, requestBody);
            return Result.succeed((Object)resp);
        }
        catch (Exception ex) {
            throw new CloudFileException((Throwable)ex);
        }
    }

    public Result delete(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucket).key(key).build();
            DeleteObjectResponse resp = this.client.deleteObject(deleteObjectRequest);
            return Result.succeed((Object)resp);
        }
        catch (Exception e) {
            throw new CloudFileException((Throwable)e);
        }
    }
}

