/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.aws.s3.service;

import java.net.URI;
import java.time.Duration;
import java.util.Base64;
import java.util.Collection;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.extend.aws.s3.service.Datetime;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.core.handle.Result;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;

public class CloudFileServiceOfS3HttpImpl
implements CloudFileService {
    private static final String CHARSET_UTF8 = "utf8";
    private static final String ALGORITHM = "HmacSHA1";
    private static final String acl_header = "x-amz-grant-read";
    private static final String acl_header_val = "uri=\"http://acs.amazonaws.com/groups/global/AllUsers\"";
    private static final String acl_canonicalized = "x-amz-grant-read:uri=\"http://acs.amazonaws.com/groups/global/AllUsers\"\n";
    private final String bucketDef;
    private final String endpoint;
    private final String regionId;
    private final String accessKey;
    private final String secretKey;
    protected final boolean isHttps;

    public CloudFileServiceOfS3HttpImpl(CloudProps cloudProps) {
        String endpointStr = cloudProps.getFileEndpoint();
        this.regionId = cloudProps.getFileRegionId();
        this.bucketDef = cloudProps.getFileBucket();
        this.accessKey = cloudProps.getFileAccessKey();
        this.secretKey = cloudProps.getFileSecretKey();
        if (Utils.isEmpty((String)this.regionId) && Utils.isEmpty((String)endpointStr)) {
            throw new CloudFileException("The 'regionId' and 'endpoint' configuration must have one");
        }
        if (Utils.isEmpty((String)endpointStr)) {
            this.isHttps = true;
        } else {
            this.isHttps = !endpointStr.startsWith("http://");
            if (endpointStr.contains("://")) {
                endpointStr = URI.create(endpointStr).getHost();
            }
        }
        this.endpoint = endpointStr;
    }

    public boolean exists(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            String objPath = "/" + bucket + "/" + key;
            String date = Datetime.Now().toGmtString();
            String stringToSign = this.buildSignData("HEAD", null, null, date, null, objPath);
            String signature = this.hmacSha1(stringToSign, this.secretKey);
            String authorization = "AWS " + this.accessKey + ":" + signature;
            String url = this.buildUrl(bucket, key);
            int code = HttpUtils.http((String)url).header("Date", date).header("Authorization", authorization).execAsCode("HEAD");
            return code == 200;
        }
        catch (Exception ex) {
            throw new CloudFileException((Throwable)ex);
        }
    }

    public String getTempUrl(String bucket, String key, Duration duration) throws CloudFileException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Media get(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            String objPath = "/" + bucket + "/" + key;
            String date = Datetime.Now().toGmtString();
            String stringToSign = this.buildSignData("GET", null, null, date, null, objPath);
            String signature = this.hmacSha1(stringToSign, this.secretKey);
            String authorization = "AWS " + this.accessKey + ":" + signature;
            String url = this.buildUrl(bucket, key);
            HttpResponse resp = HttpUtils.http((String)url).header("Date", date).header("Authorization", authorization).exec("GET");
            return new Media(resp.body(), resp.contentType(), resp.contentLength().longValue());
        }
        catch (Exception ex) {
            throw new CloudFileException((Throwable)ex);
        }
    }

    public Result put(String bucket, String key, Media media) throws CloudFileException {
        String contentType;
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        if (Utils.isEmpty((String)(contentType = media.contentType()))) {
            contentType = "text/plain; charset=utf-8";
        }
        try {
            String objPath = "/" + bucket + "/" + key;
            String date = Datetime.Now().toGmtString();
            String stringToSign = this.buildSignData("PUT", null, contentType, date, acl_canonicalized, objPath);
            String signature = this.hmacSha1(stringToSign, this.secretKey);
            String authorization = "AWS " + this.accessKey + ":" + signature;
            String url = this.buildUrl(bucket, key);
            String tmp = HttpUtils.http((String)url).header("Date", date).header("Authorization", authorization).header(acl_header, acl_header_val).bodyRaw(media.body(), contentType).put();
            return Result.succeed((Object)tmp);
        }
        catch (Exception ex) {
            throw new CloudFileException((Throwable)ex);
        }
    }

    public Result delete(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            String date = Datetime.Now().toGmtString();
            String objPath = "/" + bucket + "/" + key;
            String stringToSign = this.buildSignData("DELETE", null, null, date, null, objPath);
            String signature = this.hmacSha1(stringToSign, this.secretKey);
            String authorization = "AWS " + this.accessKey + ":" + signature;
            String url = this.buildUrl(bucket, key);
            String tmp = HttpUtils.http((String)url).header("Date", date).header("Authorization", authorization).delete();
            return Result.succeed((Object)tmp);
        }
        catch (Exception ex) {
            throw new CloudFileException((Throwable)ex);
        }
    }

    public Result deleteBatch(String bucket, Collection<String> keys) throws CloudFileException {
        for (String key : keys) {
            this.delete(bucket, key);
        }
        return Result.succeed();
    }

    private String buildUrl(String bucket, String key) {
        StringBuilder buf = new StringBuilder(100);
        if (this.isHttps) {
            buf.append("https://");
        } else {
            buf.append("http://");
        }
        buf.append(bucket).append(".");
        if (Utils.isEmpty((String)this.endpoint)) {
            buf.append("s3.");
            buf.append(this.regionId);
            buf.append(".amazonaws.com/");
            buf.append(key);
        } else {
            buf.append(this.endpoint);
            buf.append("/").append(key);
        }
        return buf.toString();
    }

    private String hmacSha1(String data, String secretKey) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            SecretKeySpec keySpec = new SecretKeySpec(secretKey.getBytes(), ALGORITHM);
            mac.init(keySpec);
            byte[] rawHmac = mac.doFinal(data.getBytes(CHARSET_UTF8));
            return Base64.getEncoder().encodeToString(rawHmac);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String buildSignData(String httpVerb, String contentMd5, String contentType, String date, String canonicalizedAmzHeaders, String canonicalizedResource) {
        StringBuilder sb = new StringBuilder();
        sb.append(httpVerb + "\n");
        if (Utils.isNotEmpty((String)contentMd5)) {
            sb.append(contentMd5 + "\n");
        } else {
            sb.append("\n");
        }
        if (Utils.isNotEmpty((String)contentType)) {
            sb.append(contentType + "\n");
        } else {
            sb.append("\n");
        }
        if (Utils.isNotEmpty((String)date)) {
            sb.append(date + "\n");
        }
        if (Utils.isNotEmpty((String)canonicalizedAmzHeaders)) {
            sb.append(canonicalizedAmzHeaders);
        }
        if (Utils.isNotEmpty((String)canonicalizedResource)) {
            sb.append(canonicalizedResource);
        }
        return sb.toString();
    }
}

