/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.aws.s3.utils;

import java.net.URI;
import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.aws.s3.utils.PolicyType;
import org.noear.solon.core.Props;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.BucketCannedACL;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

public class BucketUtils {
    public static S3Client createClient(CloudProps cloudProps) {
        String endpoint = cloudProps.getFileEndpoint();
        String regionId = cloudProps.getFileRegionId();
        String accessKey = cloudProps.getFileAccessKey();
        String secretKey = cloudProps.getFileSecretKey();
        if (accessKey == null) {
            accessKey = cloudProps.getFileUsername();
        }
        if (secretKey == null) {
            secretKey = cloudProps.getFilePassword();
        }
        if (Utils.isNotBlank((String)accessKey) && Utils.isNotBlank((String)secretKey)) {
            Props props;
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
            StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
            S3ClientBuilder builder = (S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build())).region(Region.of((String)regionId));
            if (Utils.isNotEmpty((String)endpoint)) {
                URI endpointUri = URI.create(endpoint);
                builder.endpointOverride(endpointUri);
            }
            if ((props = cloudProps.getProp("file")) != null && props.size() > 0) {
                Utils.injectProperties((Object)builder, (Properties)props);
            }
            return (S3Client)builder.build();
        }
        return (S3Client)S3Client.builder().build();
    }

    public static S3Presigner createClientPresigner(CloudProps cloudProps) {
        String endpoint = cloudProps.getFileEndpoint();
        String regionId = cloudProps.getFileRegionId();
        String accessKey = cloudProps.getFileAccessKey();
        String secretKey = cloudProps.getFileSecretKey();
        if (accessKey == null) {
            accessKey = cloudProps.getFileUsername();
        }
        if (secretKey == null) {
            secretKey = cloudProps.getFilePassword();
        }
        if (Utils.isNotBlank((String)accessKey) && Utils.isNotBlank((String)secretKey)) {
            Props props;
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
            StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
            S3Presigner.Builder builder = S3Presigner.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider).serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build()).region(Region.of((String)regionId));
            if (Utils.isNotEmpty((String)endpoint)) {
                URI endpointUri = URI.create(endpoint);
                builder.endpointOverride(endpointUri);
            }
            if ((props = cloudProps.getProp("file")) != null && props.size() > 0) {
                Utils.injectProperties((Object)builder, (Properties)props);
            }
            return builder.build();
        }
        return S3Presigner.builder().build();
    }

    public static boolean createBucket(S3Client client, String bucketName, PolicyType policyType) {
        if (BucketUtils.bucketExists(client, bucketName)) {
            return true;
        }
        if (policyType == null) {
            policyType = PolicyType.READ;
        }
        String bucketPolicy = BucketUtils.buildBucketPolicy(bucketName, policyType);
        CreateBucketRequest createBucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).acl(BucketCannedACL.PUBLIC_READ).build();
        client.createBucket(createBucketRequest);
        PutBucketPolicyRequest putBucketPolicyRequest = (PutBucketPolicyRequest)PutBucketPolicyRequest.builder().bucket(bucketName).policy(bucketPolicy).build();
        client.putBucketPolicy(putBucketPolicyRequest);
        return true;
    }

    public static boolean bucketExists(S3Client client, String bucketName) {
        try {
            HeadBucketRequest headBucketRequest = (HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build();
            client.headBucket(headBucketRequest);
            return true;
        }
        catch (NoSuchBucketException e) {
            return false;
        }
    }

    private static String buildBucketPolicy(String bucketName, PolicyType policyType) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n\"Statement\": [\n{\n\"Action\": [\n");
        if (policyType == PolicyType.WRITE) {
            builder.append("\"s3:GetBucketLocation\",\n\"s3:ListBucketMultipartUploads\"\n");
        } else if (policyType == PolicyType.READ_WRITE) {
            builder.append("\"s3:GetBucketLocation\",\n\"s3:ListBucket\",\n\"s3:ListBucketMultipartUploads\"\n");
        } else {
            builder.append("\"s3:GetBucketLocation\"\n");
        }
        builder.append("],\n\"Effect\": \"Allow\",\n\"Principal\": \"*\",\n\"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("\"\n},\n");
        if (policyType == PolicyType.READ) {
            builder.append("{\n\"Action\": [\n\"s3:ListBucket\"\n],\n\"Effect\": \"Deny\",\n\"Principal\": \"*\",\n\"Resource\": \"arn:aws:s3:::");
            builder.append(bucketName);
            builder.append("\"\n},\n");
        }
        builder.append("{\n\"Action\": ");
        switch (policyType) {
            case WRITE: {
                builder.append("[\n\"s3:AbortMultipartUpload\",\n\"s3:DeleteObject\",\n\"s3:ListMultipartUploadParts\",\n\"s3:PutObject\"\n],\n");
                break;
            }
            case READ_WRITE: {
                builder.append("[\n\"s3:AbortMultipartUpload\",\n\"s3:DeleteObject\",\n\"s3:GetObject\",\n\"s3:ListMultipartUploadParts\",\n\"s3:PutObject\"\n],\n");
                break;
            }
            default: {
                builder.append("\"s3:GetObject\",\n");
            }
        }
        builder.append("\"Effect\": \"Allow\",\n\"Principal\": \"*\",\n\"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("/*\"\n}\n],\n\"Version\": \"2012-10-17\"\n}\n");
        return builder.toString();
    }
}

