/*
 * Decompiled with CFR 0.152.
 */
package com.anji.captcha.controller;

import com.anji.captcha.model.common.ResponseModel;
import com.anji.captcha.model.vo.CaptchaVO;
import com.anji.captcha.service.CaptchaService;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Post;
import org.noear.solon.core.handle.Context;

@Controller
@Mapping(value="/captcha")
public class CaptchaController {
    @Inject
    private CaptchaService captchaService;

    @Post
    @Mapping(value="/get")
    public ResponseModel get(CaptchaVO data, Context request) {
        assert (request.realIp() != null);
        data.setBrowserInfo(CaptchaController.getRemoteId(request));
        return this.captchaService.get(data);
    }

    @Post
    @Mapping(value="/check")
    public ResponseModel check(CaptchaVO data, Context request) {
        data.setBrowserInfo(CaptchaController.getRemoteId(request));
        return this.captchaService.check(data);
    }

    public ResponseModel verify(CaptchaVO data, Context request) {
        return this.captchaService.verification(data);
    }

    public static final String getRemoteId(Context ctx) {
        return ctx.realIp() + ctx.userAgent();
    }
}

