/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.cron4j;

import java.util.concurrent.ScheduledFuture;
import org.noear.solon.core.BeanWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEntity {
    static final Logger log = LoggerFactory.getLogger(JobEntity.class);
    public final String name;
    public final String cronx;
    public final BeanWrap beanWrap;
    public final boolean enable;
    private String jobID;
    private ScheduledFuture<?> future;

    public JobEntity(String name, String cronx, boolean enable, BeanWrap beanWrap) {
        this.name = name;
        this.cronx = cronx;
        this.beanWrap = beanWrap;
        this.enable = enable;
    }

    public void start() {
        try {
            Runnable job = (Runnable)this.beanWrap.raw();
            job.run();
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public String getJobID() {
        return this.jobID;
    }

    public void setJobID(String jobID) {
        this.jobID = jobID;
    }

    public ScheduledFuture<?> getFuture() {
        return this.future;
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }
}

