/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.dami.api.impl.MethodTopicListener;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.TopicListener;
import org.noear.dami.bus.TopicListenerHolder;
import org.noear.dami.bus.TopicRouter;
import org.noear.dami.bus.impl.TopicListenPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicRouterDefault<C, R>
implements TopicRouter<C, R> {
    static final Logger log = LoggerFactory.getLogger(TopicRouterDefault.class);
    private final Map<String, TopicListenPipeline<C, R>> pipelineMap = new LinkedHashMap<String, TopicListenPipeline<C, R>>();
    protected final ReentrantLock PIPELINE_MAP_LOCK = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String topic, int index, TopicListener<Payload<C, R>> listener) {
        this.PIPELINE_MAP_LOCK.lock();
        try {
            TopicListenPipeline pipeline = this.pipelineMap.computeIfAbsent(topic, t -> new TopicListenPipeline());
            pipeline.add(index, listener);
        }
        finally {
            this.PIPELINE_MAP_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            if (MethodTopicListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("TopicRouter listener added(@{}): {}", (Object)topic, listener);
            } else {
                log.debug("TopicRouter listener added(@{}): {}", (Object)topic, (Object)listener.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String topic, TopicListener<Payload<C, R>> listener) {
        this.PIPELINE_MAP_LOCK.lock();
        try {
            TopicListenPipeline<C, R> pipeline = this.pipelineMap.get(topic);
            if (pipeline != null) {
                pipeline.remove(listener);
            }
        }
        finally {
            this.PIPELINE_MAP_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            if (MethodTopicListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("TopicRouter listener removed(@{}): {}", (Object)topic, listener);
            } else {
                log.debug("TopicRouter listener removed(@{}): {}", (Object)topic, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public void remove(String topic) {
        this.PIPELINE_MAP_LOCK.lock();
        try {
            this.pipelineMap.remove(topic);
        }
        finally {
            this.PIPELINE_MAP_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("TopicRouter listener removed(@{}): all..", (Object)topic);
        }
    }

    @Override
    public List<TopicListenerHolder<C, R>> matching(String topic) {
        TopicListenPipeline<C, R> pipeline = this.pipelineMap.get(topic);
        if (pipeline == null) {
            return null;
        }
        return pipeline.getList();
    }
}

