/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.solon.integration;

import javax.sql.DataSource;
import net.hasor.dbvisitor.dal.mapper.BaseMapper;
import net.hasor.dbvisitor.dal.repository.DalRegistry;
import net.hasor.dbvisitor.dal.session.DalSession;
import net.hasor.dbvisitor.jdbc.DynamicConnection;
import net.hasor.dbvisitor.jdbc.core.JdbcTemplate;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.solon.annotation.Db;
import net.hasor.dbvisitor.solon.integration.SolonManagedDynamicConnection;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.VarHolder;
import org.noear.solon.data.datasource.DsUtils;

public class DbBeanInjectorImpl
implements BeanInjector<Db> {
    private final DalRegistry dalRegistry;

    public DbBeanInjectorImpl(DalRegistry dalRegistry) {
        this.dalRegistry = dalRegistry;
    }

    public void doInject(VarHolder vh, Db anno) {
        vh.required(true);
        DsUtils.observeDs((AppContext)vh.context(), (String)anno.value(), dsWrap -> this.inject0(vh, (BeanWrap)dsWrap));
    }

    private void inject0(VarHolder vh, BeanWrap dsBw) {
        try {
            this.inject1(vh, dsBw);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void inject1(VarHolder vh, BeanWrap dsBw) throws Exception {
        DataSource ds = (DataSource)dsBw.get();
        Class clz = vh.getType();
        if (LambdaTemplate.class.isAssignableFrom(vh.getType())) {
            LambdaTemplate accessor = new LambdaTemplate((DynamicConnection)new SolonManagedDynamicConnection(ds));
            vh.setValue((Object)accessor);
            return;
        }
        if (JdbcTemplate.class.isAssignableFrom(vh.getType())) {
            JdbcTemplate accessor = new JdbcTemplate((DynamicConnection)new SolonManagedDynamicConnection(ds));
            vh.setValue((Object)accessor);
            return;
        }
        if (DalSession.class.isAssignableFrom(vh.getType())) {
            DalSession accessor = new DalSession((DynamicConnection)new SolonManagedDynamicConnection(ds));
            vh.setValue((Object)accessor);
            return;
        }
        if (vh.getType().isInterface()) {
            DalSession accessor = new DalSession((DynamicConnection)new SolonManagedDynamicConnection(ds), this.dalRegistry);
            if (clz == BaseMapper.class) {
                BaseMapper obj = accessor.createBaseMapper((Class)vh.getGenericType().getActualTypeArguments()[0]);
                vh.setValue((Object)obj);
            } else {
                Object mapper = accessor.createMapper(vh.getType());
                vh.setValue(mapper);
            }
            return;
        }
    }
}

