/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.dubbo.integration;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import java.net.InetSocketAddress;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.noear.solon.Solon;
import org.noear.solon.Utils;

public class DubboFilterTracing
implements Filter {
    private Tracer tracer;

    public DubboFilterTracing() {
        Solon.context().getBeanAsync(Tracer.class, bean -> {
            this.tracer = bean;
        });
    }

    /*
     * Exception decompiling
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Span buildSpan(Invoker<?> invoker, Invocation invocation, boolean isConsumerSide) {
        StringBuilder operationName = new StringBuilder();
        operationName.append("Dubbo:");
        if (!isConsumerSide) {
            InetSocketAddress address = RpcContext.getServerContext().getLocalAddress();
            operationName.append(address).append(":");
        }
        if (Utils.isNotEmpty((String)invocation.getServiceName())) {
            operationName.append(invocation.getServiceName()).append(":");
        }
        operationName.append(invocation.getMethodName());
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName.toString());
        if (isConsumerSide) {
            spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "client");
        } else {
            spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "server");
        }
        Span span = spanBuilder.start();
        this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(invocation.getAttachments()));
        return span;
    }
}

