/*
 * Decompiled with CFR 0.152.
 */
package org.noear.esearchx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.function.Consumer;
import org.noear.esearchx.EsCommand;
import org.noear.esearchx.EsCommandHolder;
import org.noear.esearchx.EsGlobal;
import org.noear.esearchx.EsQuery;
import org.noear.esearchx.PriHttpUtils;
import org.noear.esearchx.PriUtils;
import org.noear.esearchx.exception.NoExistException;
import org.noear.esearchx.model.EsAliases;
import org.noear.esearchx.model.EsSetting;
import org.noear.snack.ONode;

public class EsContext {
    private final String[] urls;
    private int urlIndex;
    private final String username;
    private final String password;
    private String meta;
    private int version = 0;
    @Deprecated
    public EsCommand lastCommand;

    public String getMeta() {
        return this.meta;
    }

    public int getVersion() {
        return this.version;
    }

    public EsContext(Properties prop) {
        String url = prop.getProperty("url");
        String passwordStr = prop.getProperty("password");
        if (PriUtils.isEmpty(passwordStr)) {
            passwordStr = prop.getProperty("paasword");
        }
        this.username = prop.getProperty("username");
        this.password = passwordStr;
        ArrayList<String> urlAry = new ArrayList<String>();
        for (String ser : url.split(",")) {
            if (ser.contains("://")) {
                urlAry.add(ser);
                continue;
            }
            urlAry.add("http://" + ser);
        }
        this.urls = urlAry.toArray(new String[urlAry.size()]);
        this.initMeta();
    }

    public EsContext(String url) {
        this(url, null, null);
    }

    public EsContext(String url, String username, String password) {
        this.username = username;
        this.password = password;
        ArrayList<String> urlAry = new ArrayList<String>();
        for (String ser : url.split(",")) {
            if (ser.contains("://")) {
                urlAry.add(ser);
                continue;
            }
            urlAry.add("http://" + ser);
        }
        this.urls = urlAry.toArray(new String[urlAry.size()]);
        this.initMeta();
    }

    private void initMeta() {
        try {
            this.meta = this.getHttp("").get();
            if (PriUtils.isEmpty(this.meta)) {
                return;
            }
            ONode oNode = ONode.loadStr((String)this.meta);
            String verString = oNode.get("version").get("number").getString();
            if (PriUtils.isEmpty(verString)) {
                return;
            }
            String varMain = verString.split("\\.")[0];
            this.version = Integer.parseInt(varMain);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String getUrl() {
        if (this.urls.length == 0) {
            return this.urls[0];
        }
        if (this.urlIndex > 10000000) {
            this.urlIndex = 0;
        }
        return this.urls[this.urlIndex % this.urls.length];
    }

    protected PriHttpUtils getHttp(String path) {
        PriHttpUtils http = PriHttpUtils.http(this.getUrl() + path);
        if (PriUtils.isNotEmpty(this.username)) {
            String token = PriUtils.b64Encode(this.username + ":" + this.password);
            String auth = "Basic " + token;
            http.header("Authorization", auth);
        }
        return http;
    }

    public String execAsBody(EsCommand cmd) throws IOException {
        this.lastCommand = cmd;
        EsCommandHolder holder = new EsCommandHolder(this, cmd);
        EsGlobal.applyCommandBefore(holder);
        long start = System.currentTimeMillis();
        String body = PriUtils.isEmpty(cmd.dsl) ? this.getHttp(cmd.path).timeout(cmd.timeout).execAsBody(cmd.method) : this.getHttp(cmd.path).bodyTxt(cmd.dsl, cmd.dslType).timeout(cmd.timeout).execAsBody(cmd.method);
        holder.setTimespan(System.currentTimeMillis() - start);
        EsGlobal.applyCommandAfter(holder);
        return body;
    }

    public int execAsCode(EsCommand cmd) throws IOException {
        this.lastCommand = cmd;
        EsCommandHolder holder = new EsCommandHolder(this, cmd);
        EsGlobal.applyCommandBefore(holder);
        long start = System.currentTimeMillis();
        int code = PriUtils.isEmpty(cmd.dsl) ? this.getHttp(cmd.path).timeout(cmd.timeout).execAsCode(cmd.method) : this.getHttp(cmd.path).bodyTxt(cmd.dsl, cmd.dslType).timeout(cmd.timeout).execAsCode(cmd.method);
        holder.setTimespan(System.currentTimeMillis() - start);
        EsGlobal.applyCommandAfter(holder);
        return code;
    }

    public EsQuery indice(String indiceName) {
        return new EsQuery(this, indiceName, false);
    }

    public String indiceCreate(String indiceName, String dsl) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "PUT";
        cmd.path = String.format("/%s", indiceName);
        cmd.dsl = dsl;
        cmd.dslType = "application/json";
        String tmp = this.execAsBody(cmd);
        return tmp;
    }

    public boolean indiceExist(String indiceName) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "HEAD";
        cmd.path = String.format("/%s", indiceName);
        int tmp = this.execAsCode(cmd);
        return tmp == 200;
    }

    public boolean indiceDrop(String indiceName) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "DELETE";
        cmd.path = String.format("/%s", indiceName);
        try {
            this.execAsBody(cmd);
            return true;
        }
        catch (NoExistException e) {
            return true;
        }
    }

    public String indiceSettings(String indiceName, Consumer<EsSetting> setting) throws IOException {
        ONode oNode1 = PriUtils.newNode();
        EsSetting s = new EsSetting(oNode1);
        setting.accept(s);
        EsCommand cmd = new EsCommand();
        cmd.method = "PUT";
        cmd.path = String.format("/%s/_settings", indiceName);
        cmd.dsl = oNode1.toJson();
        String tmp = this.execAsBody(cmd);
        return tmp;
    }

    public String indiceShow(String indiceName) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "GET";
        cmd.path = String.format("/%s", indiceName);
        String tmp = this.execAsBody(cmd);
        return tmp;
    }

    public String indiceAliases(Consumer<EsAliases> aliases) throws IOException {
        ONode oNode1 = PriUtils.newNode();
        EsAliases e = new EsAliases(oNode1);
        aliases.accept(e);
        ONode oNode = PriUtils.newNode().build(n -> n.set("actions", (Object)oNode1));
        EsCommand cmd = new EsCommand();
        cmd.method = "POST";
        cmd.dslType = "application/json";
        cmd.dsl = oNode.toJson();
        cmd.path = "/_aliases";
        String tmp = this.execAsBody(cmd);
        return tmp;
    }

    public EsQuery stream(String streamName) {
        return new EsQuery(this, streamName, true);
    }

    public String templateCreate(String templateName, String dsl) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "PUT";
        cmd.path = String.format("/_index_template/%s", templateName);
        cmd.dsl = dsl;
        cmd.dslType = "application/json";
        String tmp = this.execAsBody(cmd);
        return tmp;
    }

    public boolean templateExist(String templateName) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "HEAD";
        cmd.path = String.format("/_index_template/%s", templateName);
        int tmp = this.execAsCode(cmd);
        return tmp == 200;
    }

    public String templateShow(String templateName) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "GET";
        cmd.path = String.format("/_index_template/%s", templateName);
        String tmp = this.execAsBody(cmd);
        return tmp;
    }

    public String componentCreate(String componentName, String dsl) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "PUT";
        cmd.path = String.format("/_component_template/%s", componentName);
        cmd.dsl = dsl;
        cmd.dslType = "application/json";
        String tmp = this.execAsBody(cmd);
        return tmp;
    }

    public boolean componentExist(String componentName) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "HEAD";
        cmd.path = String.format("/_component_template/%s", componentName);
        int tmp = this.execAsCode(cmd);
        return tmp == 200;
    }

    public String componentShow(String componentName) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "GET";
        cmd.path = String.format("/_component_template/%s", componentName);
        String tmp = this.execAsBody(cmd);
        return tmp;
    }

    public String policyCreate(String policyName, String dsl) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "PUT";
        cmd.path = String.format("/_ilm/policy/%s", policyName);
        cmd.dsl = dsl;
        cmd.dslType = "application/json";
        String tmp = this.execAsBody(cmd);
        return tmp;
    }

    public boolean policyExist(String policyName) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "GET";
        cmd.path = String.format("/_ilm/policy/%s", policyName);
        int tmp = this.execAsCode(cmd);
        return tmp == 200;
    }

    public String policyShow(String policyName) throws IOException {
        EsCommand cmd = new EsCommand();
        cmd.method = "GET";
        cmd.path = String.format("/_ilm/policy/%s", policyName);
        String tmp = this.execAsBody(cmd);
        return tmp;
    }
}

