/*
 * Decompiled with CFR 0.152.
 */
package org.noear.esearchx.model;

import java.util.Arrays;
import java.util.function.Consumer;
import org.noear.esearchx.model.EsCondition;
import org.noear.esearchx.model.EsDateHistogram;
import org.noear.esearchx.model.EsHistogram;
import org.noear.esearchx.model.EsRanges;
import org.noear.esearchx.model.EsSort;
import org.noear.esearchx.model.EsTerms;
import org.noear.snack.ONode;

public class EsAggs {
    private final ONode oNode;
    private ONode lastLevel2Node;
    private String oNodeAsField;

    public EsAggs(ONode oNode) {
        this.oNode = oNode;
    }

    public EsAggs asField(String asField) {
        this.oNode.rename(this.oNodeAsField, asField);
        return this;
    }

    public EsAggs sum(String field) {
        this.funSet(field + "_sum", field, "sum");
        return this;
    }

    public EsAggs sum(String field, String asFiled) {
        this.funSet(asFiled, field, "sum");
        return this;
    }

    public EsAggs avg(String field) {
        this.funSet(field + "_avg", field, "avg");
        return this;
    }

    public EsAggs avg(String field, String asField) {
        this.funSet(asField, field, "avg");
        return this;
    }

    public EsAggs max(String field) {
        this.funSet(field + "_max", field, "max");
        return this;
    }

    public EsAggs max(String field, String asField) {
        this.funSet(asField, field, "max");
        return this;
    }

    public EsAggs min(String field) {
        this.funSet(field + "_min", field, "min");
        return this;
    }

    public EsAggs min(String field, String asField) {
        this.funSet(asField, field, "min");
        return this;
    }

    public EsAggs count(String field) {
        this.funSet(field + "_count", field, "value_count");
        return this;
    }

    public EsAggs count(String field, String asField) {
        this.funSet(asField, field, "value_count");
        return this;
    }

    public EsAggs topHits(int size) {
        return this.topHits(size, null);
    }

    public EsAggs topHits(int size, Consumer<EsSort> sort) {
        ONode top_hits = this.oNode.getOrNew("$topHits").getOrNew("top_hits");
        top_hits.set("size", (Object)size);
        if (sort != null) {
            EsSort s = new EsSort(top_hits.getOrNew("sort").asArray());
            sort.accept(s);
        }
        return this;
    }

    public EsAggs cardinality(String field) {
        this.funSet(field + "_cardinality", field, "cardinality");
        return this;
    }

    public EsAggs cardinality(String field, String asField) {
        this.funSet(asField, field, "cardinality");
        return this;
    }

    public EsAggs percentiles(String field, Number[] percents) {
        ONode oNode1 = this.getLevel2Node(field + "_percentiles").getOrNew("percentiles");
        oNode1.set("field", (Object)field);
        oNode1.getOrNew("percents").addAll(Arrays.asList(percents));
        return this;
    }

    public EsAggs percentiles(String field, String asField, Number[] percents) {
        ONode oNode1 = this.getLevel2Node(asField).getOrNew("percentiles");
        oNode1.set("field", (Object)field);
        oNode1.getOrNew("percents").addAll(Arrays.asList(percents));
        return this;
    }

    public EsAggs percentilesRank(String field, Number[] values) {
        ONode oNode1 = this.getLevel2Node(field + "_percentilesRank").getOrNew("percentile_ranks");
        oNode1.set("field", (Object)field);
        oNode1.getOrNew("values").addAll(Arrays.asList(values));
        return this;
    }

    public EsAggs percentilesRank(String field, String asField, Number[] values) {
        ONode oNode1 = this.getLevel2Node(asField).getOrNew("percentile_ranks");
        oNode1.set("field", (Object)field);
        oNode1.getOrNew("values").addAll(Arrays.asList(values));
        return this;
    }

    public EsAggs extendedStats(String field) {
        this.funSet(field + "_extendedStats", field, "extended_stats");
        return this;
    }

    public EsAggs extendedStats(String field, String asField) {
        this.funSet(asField, field, "extended_stats");
        return this;
    }

    public EsAggs stats(String field) {
        this.funSet(field + "_stats", field, "stats");
        return this;
    }

    public EsAggs stats(String field, String asField) {
        this.funSet(asField, field, "stats");
        return this;
    }

    public EsAggs filter(Consumer<EsCondition> condition) {
        EsCondition c = new EsCondition(this.getLevel2Node("$filter").getOrNew("filter"));
        condition.accept(c);
        return this;
    }

    public EsAggs range(String field, Consumer<EsRanges> ranges) {
        ONode oNode1 = this.getLevel2Node(field + "_range").getOrNew("range");
        oNode1.set("field", (Object)field);
        EsRanges t = new EsRanges(oNode1.getOrNew("ranges").asArray());
        ranges.accept(t);
        return this;
    }

    public EsAggs range(String field, String asField, Consumer<EsRanges> ranges) {
        ONode oNode1 = this.getLevel2Node(asField).getOrNew("range");
        oNode1.set("field", (Object)field);
        EsRanges t = new EsRanges(oNode1.getOrNew("ranges").asArray());
        ranges.accept(t);
        return this;
    }

    public EsAggs terms(String field) {
        this.terms(field, field + "_terms");
        return this;
    }

    public EsAggs terms(String field, String asField) {
        this.terms(field, asField, null);
        return this;
    }

    public EsAggs terms(String field, Consumer<EsTerms> terms) {
        ONode oNode1 = this.getLevel2Node(field + "_terms").getOrNew("terms");
        if (field.startsWith("$")) {
            oNode1.set("script", (Object)field.substring(1));
        } else {
            oNode1.set("field", (Object)field);
        }
        if (terms != null) {
            EsTerms t = new EsTerms(oNode1);
            terms.accept(t);
        }
        return this;
    }

    public EsAggs terms(String field, String asField, Consumer<EsTerms> terms) {
        ONode oNode1 = this.getLevel2Node(asField).getOrNew("terms");
        if (field.startsWith("$")) {
            oNode1.set("script", (Object)field.substring(1));
        } else {
            oNode1.set("field", (Object)field);
        }
        if (terms != null) {
            EsTerms t = new EsTerms(oNode1);
            terms.accept(t);
        }
        return this;
    }

    public EsAggs dateHistogram(String field, Consumer<EsDateHistogram> dateHistogram) {
        return this.dateHistogram(field, field + "_date_histogram", dateHistogram);
    }

    public EsAggs dateHistogram(String field, String asField, Consumer<EsDateHistogram> dateHistogram) {
        ONode oNode1 = this.getLevel2Node(asField).getOrNew("date_histogram");
        oNode1.set("field", (Object)field);
        if (dateHistogram != null) {
            EsDateHistogram t = new EsDateHistogram(oNode1);
            dateHistogram.accept(t);
        }
        return this;
    }

    public EsAggs histogram(String field, Consumer<EsHistogram> histogram) {
        return this.histogram(field, field + "_histogram", histogram);
    }

    public EsAggs histogram(String field, String asField, Consumer<EsHistogram> histogram) {
        ONode oNode1 = this.getLevel2Node(asField).getOrNew("histogram");
        oNode1.set("field", (Object)field);
        if (histogram != null) {
            EsHistogram t = new EsHistogram(oNode1);
            histogram.accept(t);
        }
        return this;
    }

    public EsAggs aggs(Consumer<EsAggs> aggs) {
        if (this.lastLevel2Node == null) {
            throw new IllegalArgumentException("There are no secondary nodes");
        }
        EsAggs c = new EsAggs(this.lastLevel2Node.getOrNew("aggs"));
        aggs.accept(c);
        return this;
    }

    private ONode getLevel2Node(String name) {
        this.oNodeAsField = name;
        this.lastLevel2Node = this.oNode.getOrNew(name);
        return this.lastLevel2Node;
    }

    private void funSet(String asField, String field, String funName) {
        this.getLevel2Node(asField).getOrNew(funName).set("field", (Object)field);
    }
}

