/*
 * Decompiled with CFR 0.152.
 */
package org.noear.esearchx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.esearchx.PriUtils;
import org.noear.esearchx.model.EsMap;
import org.noear.esearchx.model.EsRange;
import org.noear.snack.ONode;

public class EsCondition {
    private final ONode oNode;
    ONode oNodeArray = null;
    String score_mode = null;

    public EsCondition(ONode oNode) {
        this.oNode = oNode;
    }

    private void filterStyleSet(String name) {
        if (this.score_mode == null) {
            this.oNodeArray = this.oNode.getOrNew("bool").getOrNew(name).asArray();
        } else {
            this.oNodeArray = this.oNode.getOrNew("function_score").getOrNew("query").getOrNew("bool").getOrNew(name).asArray();
            if (this.score_mode.length() > 0) {
                this.oNode.getOrNew("function_score").set("score_mode", (Object)this.score_mode);
            }
        }
    }

    private void filterSet(String type, String field, Object value) {
        if (this.oNodeArray == null) {
            if (this.score_mode == null) {
                this.oNode.getOrNew(type).set(field, value);
            } else {
                this.oNode.getOrNew("function_score").getOrNew("query").getOrNew(type).set(field, value);
                if (this.score_mode.length() > 0) {
                    this.oNode.getOrNew("function_score").set("score_mode", (Object)this.score_mode);
                }
            }
        } else {
            this.oNodeArray.add((Object)PriUtils.newNode().build(n -> n.getOrNew(type).set(field, value)));
        }
    }

    public EsCondition useScore() {
        return this.useScore(null);
    }

    public EsCondition useScore(String mode) {
        this.score_mode = mode == null ? "" : null;
        return this;
    }

    public EsCondition filter() {
        this.filterStyleSet("filter");
        return this;
    }

    public EsCondition must() {
        this.filterStyleSet("must");
        return this;
    }

    public EsCondition should() {
        this.filterStyleSet("should");
        return this;
    }

    public EsCondition minimumShouldMatch(int min) {
        this.oNode.getOrNew("bool").set("minimum_should_match", (Object)min);
        return this;
    }

    public EsCondition mustNot() {
        this.filterStyleSet("must_not");
        return this;
    }

    public void matchAll() {
        this.oNode.getOrNew("match_all").asObject();
    }

    public EsCondition nested(String path, Consumer<EsCondition> condition) {
        if (this.oNodeArray == null) {
            this.oNodeArray = PriUtils.newNode().asArray();
        }
        ONode oNode1 = PriUtils.newNode();
        EsCondition c = new EsCondition(oNode1);
        condition.accept(c);
        this.oNodeArray.addNew().getOrNew("nested").set("path", (Object)path).set("query", (Object)oNode1);
        return this;
    }

    public EsCondition match(String field, Object value) {
        this.filterSet("match", field, value);
        return this;
    }

    public EsCondition matchIf(boolean condition, String field, Object value) {
        return condition ? this.match(field, value) : this;
    }

    public EsCondition matchPhrase(String field, Object value) {
        this.filterSet("match_phrase", field, value);
        return this;
    }

    public EsCondition matchPhraseIf(boolean condition, String field, Object value) {
        return condition ? this.matchPhrase(field, value) : this;
    }

    public EsCondition matchPhrase(String field, Object value, int slop) {
        ONode oNode = PriUtils.newNode();
        oNode.set("query", value);
        oNode.set("slop", (Object)slop);
        this.filterSet("match_phrase", field, oNode);
        return this;
    }

    public EsCondition matchPhraseIf(boolean condition, String field, Object value, int slop) {
        return condition ? this.matchPhrase(field, value, slop) : this;
    }

    public EsCondition matchPhrasePrefix(String field, Object value) {
        this.filterSet("match_phrase_prefix", field, value);
        return this;
    }

    public EsCondition matchPhrasePrefixIf(boolean condition, String field, Object value) {
        return condition ? this.matchPhrasePrefix(field, value) : this;
    }

    public EsCondition matchPhrasePrefix(String field, Object value, int slop) {
        ONode oNode = PriUtils.newNode();
        oNode.set("query", value);
        oNode.set("slop", (Object)slop);
        this.filterSet("match_phrase_prefix", field, oNode);
        return this;
    }

    public EsCondition matchPhrasePrefixIf(boolean condition, String field, Object value, int slop) {
        return condition ? this.matchPhrasePrefix(field, value, slop) : this;
    }

    public EsCondition exists(String field) {
        this.filterSet("exists", "field", field);
        return this;
    }

    public EsCondition existsIf(boolean condition, String field) {
        return condition ? this.exists(field) : this;
    }

    public EsCondition term(String field, Object value) {
        this.filterSet("term", field, value);
        return this;
    }

    public EsCondition termIf(boolean condition, String field, Object value) {
        return condition ? this.term(field, value) : this;
    }

    public EsCondition terms(String field, Object ... values) {
        this.filterSet("terms", field, PriUtils.newNode().addAll(Arrays.asList(values)));
        return this;
    }

    public EsCondition terms(String field, Collection<?> values) {
        this.filterSet("terms", field, PriUtils.newNode().addAll(values));
        return this;
    }

    public EsCondition termsIf(boolean condition, String field, Object ... values) {
        return condition ? this.terms(field, values) : this;
    }

    public EsCondition termsIf(boolean condition, String field, Collection<?> values) {
        return condition ? this.terms(field, values) : this;
    }

    public EsCondition range(String field, Consumer<EsRange> range) {
        ONode oNode1 = PriUtils.newNode();
        EsRange r = new EsRange(oNode1);
        range.accept(r);
        this.filterSet("range", field, oNode1);
        return this;
    }

    public EsCondition rangeIf(boolean condition, String field, Consumer<EsRange> range) {
        return condition ? this.range(field, range) : this;
    }

    public EsCondition prefix(String field, String value) {
        this.filterSet("prefix", field, value);
        return this;
    }

    public EsCondition prefixIf(boolean condition, String field, String value) {
        return condition ? this.prefix(field, value) : this;
    }

    public EsCondition wildcard(String field, String value) {
        this.filterSet("wildcard", field, value);
        return this;
    }

    public EsCondition wildcardIf(boolean condition, String field, String value) {
        return condition ? this.wildcard(field, value) : this;
    }

    public EsCondition regexp(String field, String value) {
        this.filterSet("regexp", field, value);
        return this;
    }

    public EsCondition regexpIf(boolean condition, String field, String value) {
        return condition ? this.regexp(field, value) : this;
    }

    public EsCondition script(String source, Consumer<EsMap> params) {
        return this.script(source, "painless", params);
    }

    public EsCondition script(String source, String lang, Consumer<EsMap> params) {
        EsMap p = new EsMap();
        params.accept(p);
        ONode oNode = PriUtils.newNode();
        oNode.set("source", (Object)source);
        oNode.set("lang", (Object)lang);
        if (p.size() > 0) {
            oNode.getOrNew("params").setAll((Map)p);
        }
        this.filterSet("script", "script", oNode);
        return this;
    }

    public EsCondition add(Consumer<EsCondition> condition) {
        if (this.oNodeArray == null) {
            throw new IllegalArgumentException("Conditions lack combination types");
        }
        EsCondition c = new EsCondition(this.oNodeArray.addNew());
        condition.accept(c);
        return this;
    }
}

