/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.noear.folkmq.client.MqConsumeHandler;
import org.noear.folkmq.client.MqMessageReceived;

public class MqRouter
implements MqConsumeHandler {
    private final Function<MqMessageReceived, String> mappingHandler;
    private final Map<String, MqConsumeHandler> mappingMap = new HashMap<String, MqConsumeHandler>();
    private MqConsumeHandler consumeHandler;

    public MqRouter(Function<MqMessageReceived, String> mappingHandler) {
        this.mappingHandler = mappingHandler;
    }

    public MqRouter doOn(String mapping, MqConsumeHandler consumeHandler) {
        this.mappingMap.put(mapping, consumeHandler);
        return this;
    }

    public MqRouter doOnConsume(MqConsumeHandler consumeHandler) {
        this.consumeHandler = consumeHandler;
        return this;
    }

    @Override
    public void consume(MqMessageReceived message) throws Exception {
        String mapping;
        MqConsumeHandler handler;
        if (this.consumeHandler != null) {
            this.consumeHandler.consume(message);
        }
        if ((handler = this.mappingMap.get(mapping = this.mappingHandler.apply(message))) != null) {
            handler.consume(message);
        }
    }
}

