/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.noear.folkmq.client.MqClientInternal;
import org.noear.folkmq.client.MqMessage;
import org.noear.folkmq.client.MqTransaction;
import org.noear.socketd.utils.StrUtils;

public class MqTransactionImpl
implements MqTransaction {
    private final MqClientInternal client;
    private final List<String> keyAry;
    private final String tmid;

    public MqTransactionImpl(MqClientInternal client) {
        this.client = client;
        this.keyAry = new ArrayList<String>();
        this.tmid = StrUtils.guid();
    }

    @Override
    public String tmid() {
        return this.tmid;
    }

    @Override
    public void binding(MqMessage message) {
        this.keyAry.add(message.getKey());
        message.internalSender(this.client.name());
    }

    @Override
    public void commit() throws IOException {
        this.client.publish2(this.tmid, this.keyAry, false);
    }

    @Override
    public void rollback() throws IOException {
        this.client.publish2(this.tmid, this.keyAry, true);
    }
}

