/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.common;

import java.util.Map;
import org.noear.folkmq.client.MqMessage;
import org.noear.folkmq.common.MqMetasResolver;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.entity.MessageBuilder;
import org.noear.socketd.utils.StrUtils;

public class MqMetasResolverV1
implements MqMetasResolver {
    @Override
    public int version() {
        return 1;
    }

    @Override
    public String getSender(Entity m) {
        return m.metaOrDefault("s0", "");
    }

    @Override
    public String getKey(Entity m) {
        return m.metaOrDefault("mq.tid", "");
    }

    @Override
    public String getTag(Entity m) {
        return m.metaOrDefault("t5", "");
    }

    @Override
    public String getTopic(Entity m) {
        return m.metaOrDefault("mq.topic", "");
    }

    @Override
    public String getConsumerGroup(Entity m) {
        return m.metaOrDefault("mq.consumer", "");
    }

    @Override
    public void setConsumerGroup(Entity m, String consumerGroup) {
        m.putMeta("mq.consumer", consumerGroup);
    }

    @Override
    public int getQos(Entity m) {
        return "0".equals(m.meta("mq.qos")) ? 0 : 1;
    }

    @Override
    public int getTimes(Entity m) {
        return Integer.parseInt(m.metaOrDefault("mq.times", "0"));
    }

    @Override
    public void setTimes(Entity m, int times) {
        m.putMeta("mq.times", String.valueOf(times));
    }

    @Override
    public long getExpiration(Entity m) {
        return Long.parseLong(m.metaOrDefault("mq.expiration", "0"));
    }

    @Override
    public void setExpiration(Entity m, Long expiration) {
        if (expiration == null) {
            m.delMeta("mq.expiration");
        } else {
            m.putMeta("mq.expiration", expiration.toString());
        }
    }

    @Override
    public long getScheduled(Entity m) {
        return Long.parseLong(m.metaOrDefault("mq.scheduled", "0"));
    }

    @Override
    public void setScheduled(Entity m, long scheduled) {
        m.putMeta("mq.scheduled", String.valueOf(scheduled));
    }

    @Override
    public boolean isSequence(Entity m) {
        return "1".equals(m.metaOrDefault("mq.sequence", "0"));
    }

    @Override
    public boolean isTransaction(Entity m) {
        return "1".equals(m.meta("t4"));
    }

    @Override
    public void setTransaction(Entity m, boolean isTransaction) {
        m.putMeta("t4", isTransaction ? "1" : "0");
    }

    @Override
    public EntityDefault publishEntityBuild(String topic, MqMessage message) {
        EntityDefault entity = new EntityDefault().dataSet(message.getBody());
        entity.metaPut("mq.tid", message.getKey());
        entity.metaPut("mq.topic", topic);
        entity.metaPut("mq.qos", message.getQos() == 0 ? "0" : "1");
        if (StrUtils.isNotEmpty((String)message.getTag())) {
            entity.metaPut("t5", message.getTag());
        }
        if (message.getScheduled() == null) {
            entity.metaPut("mq.scheduled", "0");
        } else {
            entity.metaPut("mq.scheduled", String.valueOf(message.getScheduled().getTime()));
        }
        if (message.getExpiration() != null) {
            entity.metaPut("mq.expiration", String.valueOf(message.getExpiration().getTime()));
        }
        if (message.isTransaction()) {
            entity.metaPut("t4", "1");
        }
        if (StrUtils.isNotEmpty((String)message.getSender())) {
            entity.metaPut("s0", message.getSender());
        }
        if (message.isSequence() || message.isTransaction()) {
            entity.at("folkmq-server!");
            if (message.isSequence()) {
                entity.metaPut("mq.sequence", "1");
            }
        } else {
            entity.at("folkmq-server");
        }
        for (Map.Entry<String, String> kv : message.getAttrMap().entrySet()) {
            entity.putMeta("!" + kv.getKey(), kv.getValue());
        }
        return entity;
    }

    @Override
    public Message routingMessageBuild(String topic, MqMessage message) {
        EntityDefault entity = this.publishEntityBuild(topic, message).at("folkmq-server");
        MessageInternal messageDefault = new MessageBuilder().flag(40).sid(StrUtils.guid()).event("mq.event.publish").entity((Entity)entity).build();
        return messageDefault;
    }
}

