/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.server;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.folkmq.common.MqMetasResolver;
import org.noear.folkmq.server.MqNextTime;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.entity.EntityDefault;

public class MqMessageHolder
implements Delayed {
    protected final MqMetasResolver mr;
    private final String sender;
    private final EntityDefault entity;
    private final String key;
    private final String atName;
    private final int qos;
    private final long expiration;
    private final boolean sequence;
    private final String sequenceSharding;
    private boolean transaction;
    private volatile long distributeTime;
    private volatile long distributeTimeRef;
    private volatile int distributeCount;
    private volatile long distributeIdx;
    private AtomicBoolean isDone;

    public MqMessageHolder(MqMetasResolver mr, String queueName, String consumerGroup, Message from, String key, int qos, boolean sequence, long expiration, boolean transaction, String sender, int distributeCount, long distributeTime) {
        this.mr = mr;
        this.atName = from.atName();
        this.sender = sender;
        this.entity = new EntityDefault().dataSet(from.data()).metaMapPut(from.metaMap());
        mr.setConsumerGroup((Entity)this.entity, consumerGroup);
        this.isDone = new AtomicBoolean();
        this.key = key;
        this.qos = qos;
        this.expiration = expiration;
        this.sequence = sequence;
        this.sequenceSharding = from.meta("X-Hash");
        this.transaction = transaction;
        this.distributeCount = distributeCount;
        this.distributeTime = this.distributeTimeRef = distributeTime;
        if (sequence) {
            this.entity.at(queueName);
        } else {
            this.entity.at(queueName + "!");
        }
        if (transaction) {
            this.entity.at(sender);
        }
    }

    public String getSender() {
        return this.sender;
    }

    public String getAtName() {
        return this.atName;
    }

    public String getKey() {
        return this.key;
    }

    public EntityDefault getEntity() {
        return this.entity;
    }

    public int getQos() {
        return this.qos;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public boolean isTransaction() {
        return this.transaction;
    }

    public MqMessageHolder noTransaction() {
        this.transaction = false;
        this.distributeCount = 0;
        this.distributeTime = this.distributeTimeRef = System.currentTimeMillis();
        this.mr.setTimes((Entity)this.entity, this.distributeCount);
        this.mr.setScheduled((Entity)this.entity, this.distributeTime);
        this.mr.setExpiration((Entity)this.entity, null);
        this.mr.setTransaction((Entity)this.entity, false);
        return this;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public String getSequenceSharding() {
        return this.sequenceSharding;
    }

    public void setDistributeTime(long distributeTime) {
        this.distributeTimeRef = distributeTime;
        if (!this.isSequence()) {
            this.distributeTime = this.distributeTimeRef;
        }
    }

    public void setDistributeIdx(long distributeIdx) {
        this.distributeIdx = distributeIdx;
    }

    public long getDistributeTime() {
        return this.distributeTime;
    }

    public long getDistributeTimeRef() {
        return this.distributeTimeRef;
    }

    public int getDistributeCount() {
        return this.distributeCount;
    }

    public boolean isDone() {
        return this.isDone.get();
    }

    public void setDone(boolean done) {
        this.isDone.set(done);
    }

    public MqMessageHolder delayed() {
        ++this.distributeCount;
        this.distributeTimeRef = MqNextTime.getNextTime(this);
        this.mr.setTimes((Entity)this.entity, this.distributeCount);
        if (!this.isSequence()) {
            this.distributeTime = this.distributeTimeRef;
            this.mr.setScheduled((Entity)this.entity, this.distributeTimeRef);
        }
        return this;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.distributeTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (this == o) {
            return 0;
        }
        MqMessageHolder dst = (MqMessageHolder)o;
        long diff = this.distributeTime - dst.distributeTime;
        if (diff == 0L) {
            if (this.distributeIdx < dst.distributeIdx) {
                return -1;
            }
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 1;
    }
}

