/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.server;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.folkmq.server.MqMessageHolder;
import org.noear.folkmq.server.MqQueue;
import org.noear.socketd.cluster.LoadBalancer;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.utils.StrUtils;

public abstract class MqQueueBase
implements MqQueue {
    protected final Map<String, MqMessageHolder> messageMap;
    protected final DelayQueue<MqMessageHolder> messageQueue;
    protected final AtomicLong messageDistributeTime = new AtomicLong(0L);
    protected final AtomicLong messageIndexer = new AtomicLong();
    protected final ReentrantLock messageAddLock = new ReentrantLock(true);
    private final List<Session> consumerSessions = new CopyOnWriteArrayList<Session>();
    private final LongAdder[] messageCounters = new LongAdder[9];

    public MqQueueBase() {
        this.messageMap = new ConcurrentHashMap<String, MqMessageHolder>();
        this.messageQueue = new DelayQueue();
        for (int i = 0; i < this.messageCounters.length; ++i) {
            this.messageCounters[i] = new LongAdder();
        }
    }

    public void messageCountAdd(MqMessageHolder mh) {
        int n = mh.getDistributeCount();
        if (n > 7) {
            this.messageCounters[8].increment();
        } else {
            this.messageCounters[n].increment();
        }
    }

    public void messageCountSub(MqMessageHolder mh) {
        int n = mh.getDistributeCount();
        if (n > 7) {
            this.messageCounters[8].decrement();
        } else {
            this.messageCounters[n].decrement();
        }
    }

    public long messageCount(int n) {
        if (n > 7) {
            return this.messageCounters[8].longValue();
        }
        return this.messageCounters[n].longValue();
    }

    @Override
    public int sessionCount() {
        return this.consumerSessions.size();
    }

    @Override
    public void addSession(Session session) {
        if (!this.consumerSessions.contains(session)) {
            this.consumerSessions.add(session);
        }
    }

    @Override
    public void removeSession(Session session) {
        this.consumerSessions.remove(session);
    }

    @Override
    public Collection<Session> getSessions() {
        return this.consumerSessions;
    }

    protected Session getSessionOne(MqMessageHolder messageHolder) {
        if (messageHolder.isSequence()) {
            if (StrUtils.isEmpty((String)messageHolder.getSequenceSharding())) {
                return (Session)LoadBalancer.getAnyByHash(this.consumerSessions, (String)this.getTopic());
            }
            return (Session)LoadBalancer.getAnyByHash(this.consumerSessions, (String)messageHolder.getSequenceSharding());
        }
        return (Session)LoadBalancer.getAnyByPoll(this.consumerSessions);
    }

    @Override
    public int messageTotal() {
        return this.messageMap.size();
    }

    @Override
    public int messageTotal2() {
        return this.messageQueue.size();
    }

    @Override
    public void close() {
        this.consumerSessions.clear();
        this.messageQueue.clear();
        this.messageMap.clear();
    }
}

