/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.server;

import java.util.Map;
import org.noear.folkmq.server.MqServer;
import org.noear.folkmq.server.MqServiceInternal;
import org.noear.folkmq.server.MqServiceListener;
import org.noear.folkmq.server.MqWatcher;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.transport.server.ServerConfigHandler;
import org.noear.socketd.utils.StrUtils;

public class MqServerDefault
implements MqServer {
    private final MqServiceListener serverListener;
    private final String serverSchema;
    private Server server;
    private ServerConfigHandler serverConfigHandler;

    public MqServerDefault(String schema, MqServiceListener serverListener) {
        this.serverSchema = StrUtils.isEmpty((String)schema) ? "sd:tcp" : schema;
        this.serverListener = serverListener == null ? new MqServiceListener(false) : serverListener;
    }

    public MqServerDefault(String schema) {
        this(schema, null);
    }

    public MqServerDefault() {
        this(null, null);
    }

    @Override
    public MqServer config(ServerConfigHandler configHandler) {
        this.serverConfigHandler = configHandler;
        return this;
    }

    @Override
    public MqServer watcher(MqWatcher watcher) {
        this.serverListener.watcher(watcher);
        return this;
    }

    @Override
    public MqServer addAccess(String accessKey, String accessSecretKey) {
        this.serverListener.addAccess(accessKey, accessSecretKey);
        return this;
    }

    @Override
    public MqServer addAccessAll(Map<String, String> accessMap) {
        this.serverListener.addAccessAll(accessMap);
        return this;
    }

    @Override
    public MqServer start(int port) throws Exception {
        this.server = SocketD.createServer((String)this.serverSchema);
        this.server.config(c -> {
            ServerConfig cfr_ignored_0 = (ServerConfig)((ServerConfig)((ServerConfig)((ServerConfig)c.serialSend(true)).ioThreads(1)).codecThreads(1)).exchangeThreads(1);
        });
        if (this.serverConfigHandler != null) {
            this.server.config(this.serverConfigHandler);
        }
        this.server.config(c -> c.port(port)).listen((Listener)this.serverListener);
        this.serverListener.start(() -> this.server.start());
        return this;
    }

    @Override
    public void prestop() {
        this.server.prestop();
    }

    @Override
    public void stop() {
        this.serverListener.stop(() -> this.server.stop());
    }

    @Override
    public MqServiceInternal getServerInternal() {
        return this.serverListener;
    }
}

