/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.noear.folkmq.FolkMQ;
import org.noear.folkmq.common.MqMetasResolver;
import org.noear.folkmq.common.MqUtils;
import org.noear.folkmq.server.MqQueue;
import org.noear.folkmq.server.MqServiceInternal;
import org.noear.folkmq.server.MqServiceListenerBase;
import org.noear.folkmq.server.MqWatcher;
import org.noear.folkmq.server.MqWatcherDefault;
import org.noear.folkmq.server.OnStart;
import org.noear.snack.ONode;
import org.noear.socketd.broker.BrokerListener;
import org.noear.socketd.exception.SocketDAlarmException;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.entity.StringEntity;
import org.noear.socketd.transport.core.listener.MessageHandler;
import org.noear.socketd.utils.RunUtils;

public class MqServiceListener
extends MqServiceListenerBase
implements MqServiceInternal {
    protected BrokerListener brokerListener = new BrokerListener();

    public MqServiceListener(boolean brokerMode) {
        this.brokerMode = brokerMode;
        this.distributeThread = new Thread(this::distributeDo, "distributeThread");
        this.watcher = new MqWatcherDefault();
        this.watcher.init(this);
        this.doOn("mq.event.subscribe", (s, m) -> {
            this.onSubscribe(s, m);
            this.confirmDo(s, m);
        });
        this.doOn("mq.event.unsubscribe", (s, m) -> {
            this.onUnsubscribe(s, m);
            this.confirmDo(s, m);
        });
        this.doOn("mq.event.publish", (s, m) -> {
            MqMetasResolver mr = MqUtils.getOf(m);
            boolean isTrans = mr.isTransaction((Entity)m);
            if (isTrans) {
                mr.setExpiration((Entity)m, System.currentTimeMillis() + 3600000L);
                mr.setScheduled((Entity)m, System.currentTimeMillis() + 60000L);
                String key = mr.getKey((Entity)m);
                String topic = mr.getTopic((Entity)m);
                String queueName = topic + "#" + "!";
                this.transactionMessageMap.put(key, topic);
                this.queueGetOrInit(topic, "!", queueName);
                this.routingToQueueName(mr, m, queueName);
            } else {
                this.onPublish(s, m, mr);
            }
            this.confirmDo(s, m);
        });
        this.doOn("mq.event.publish2", (s, m) -> {
            boolean isRollback = "1".equals(m.meta("mq.rollback"));
            String[] keyAry = m.dataAsString().split(",");
            boolean confirmIsOk = true;
            String confirmHint = "";
            if (!isRollback) {
                for (String key : keyAry) {
                    if (this.transactionMessageMap.containsKey(key)) continue;
                    confirmIsOk = false;
                    confirmHint = confirmHint.length() > 0 ? confirmHint + "," + key : "Transaction messages have failed to be published: " + key;
                }
            }
            if (confirmIsOk) {
                for (String key : keyAry) {
                    String queueName;
                    MqQueue queue;
                    String topic = (String)this.transactionMessageMap.remove(key);
                    if (topic == null || (queue = this.getQueue(queueName = topic + "#" + "!")) == null) continue;
                    queue.affirmAt(key, isRollback);
                }
            }
            this.confirmDo(s, m, confirmIsOk, confirmHint);
        });
        this.doOn("mq.event.unpublish", (s, m) -> {
            this.onUnpublish(s, m);
            this.confirmDo(s, m);
        });
        this.doOn("mq.event.save", (s, m) -> RunUtils.asyncAndTry(() -> {
            this.save();
            this.confirmDo(s, m);
        }));
        this.doOn("mq.event.request", (s, m) -> {
            String atName = m.atName();
            Session responder = this.brokerListener.getPlayerAny(atName, s, m);
            if (responder != null && responder.isValid()) {
                try {
                    this.brokerListener.forwardToSession(s, m, responder);
                }
                catch (Throwable e) {
                    s.sendAlarm(m, "Server forward '@" + atName + "' error: " + e.getMessage());
                }
            } else {
                s.sendAlarm(m, "Server don't have '@" + atName + "' session");
            }
        });
    }

    public MqServiceListener watcher(MqWatcher watcher) {
        if (watcher != null) {
            this.watcher = watcher;
            this.watcher.init(this);
        }
        return this;
    }

    public MqServiceListener addAccess(String accessKey, String accessSecretKey) {
        this.serverAccessMap.put(accessKey, accessSecretKey);
        return this;
    }

    public MqServiceListener addAccessAll(Map<String, String> accessMap) {
        if (accessMap != null) {
            this.serverAccessMap.putAll(accessMap);
        }
        return this;
    }

    @Override
    public void save() {
        this.watcher.onSave();
    }

    public void start(OnStart onStart) throws Exception {
        this.watcher.onStartBefore();
        if (onStart != null) {
            onStart.run();
        }
        this.distributeThread.start();
        this.watcher.onStartAfter();
        this.isStarted.set(true);
    }

    public void stop(Runnable onStop) {
        this.watcher.onStopBefore();
        if (onStop != null) {
            onStop.run();
        }
        this.distributeThread.interrupt();
        this.watcher.onStopAfter();
        ArrayList queueList = new ArrayList(this.queueMap.values());
        for (MqQueue queue : queueList) {
            queue.close();
        }
        this.isStarted.set(false);
    }

    public void onOpen(Session session) throws IOException {
        super.onOpen(session);
        session.handshake().outMeta("folkmq-version", FolkMQ.versionCodeAsString());
        if (this.brokerMode) {
            session.send("mq.event.join", (Entity)new StringEntity(""));
            log.info("Broker channel opened, sessionId={}", (Object)session.sessionId());
        } else {
            if (!this.auth(session)) {
                session.close();
                return;
            }
            log.info("Client channel opened, sessionId={}", (Object)session.sessionId());
        }
        this.sessionAllMap.put(session.sessionId(), session);
        this.brokerListener.onOpen(session);
    }

    protected boolean auth(Session session) {
        if (this.serverAccessMap.size() > 0) {
            String accessKey = session.param("ak");
            String accessSecretKey = session.param("sk");
            if (accessKey == null || accessSecretKey == null) {
                return false;
            }
            if (!accessSecretKey.equals(this.serverAccessMap.get(accessKey))) {
                return false;
            }
        }
        return true;
    }

    public void onClose(Session session) {
        super.onClose(session);
        log.info("Server channel closed, sessionId={}", (Object)session.sessionId());
        ArrayList queueNameList = new ArrayList(session.attrMap().keySet());
        for (String queueName : queueNameList) {
            MqQueue queue = (MqQueue)this.queueMap.get(queueName);
            if (queue == null) continue;
            queue.removeSession(session);
        }
        this.brokerListener.onClose(session);
    }

    public void onError(Session session, Throwable error) {
        super.onError(session, error);
        if (log.isWarnEnabled()) {
            if (error instanceof SocketDAlarmException) {
                SocketDAlarmException alarmException = (SocketDAlarmException)error;
                log.warn("Server channel error, sessionId={}, from={}", new Object[]{session.sessionId(), alarmException.getAlarm(), error});
            } else {
                log.warn("Server channel error, sessionId={}", (Object)session.sessionId(), (Object)error);
            }
        }
    }

    @Override
    public void doOnEvent(String event, MessageHandler handler) {
        this.doOn(event, handler);
    }

    protected void onSubscribe(Session s, Message m) throws IOException {
        String is_batch = m.meta("mq.batch");
        if ("1".equals(is_batch)) {
            ONode oNode = ONode.loadStr((String)m.dataAsString());
            Map subscribeData = (Map)oNode.toObject();
            if (subscribeData != null) {
                for (Map.Entry kv : subscribeData.entrySet()) {
                    for (String queueName : (Collection)kv.getValue()) {
                        String consumerGroup = queueName.split("#")[1];
                        this.watcher.onSubscribe((String)kv.getKey(), consumerGroup, s);
                        this.subscribeDo((String)kv.getKey(), consumerGroup, s);
                    }
                }
            }
        } else {
            String topic = m.meta("mq.topic");
            String consumerGroup = m.meta("mq.consumer");
            this.watcher.onSubscribe(topic, consumerGroup, s);
            this.subscribeDo(topic, consumerGroup, s);
        }
    }

    protected void onUnsubscribe(Session s, Message m) throws IOException {
        String topic = m.meta("mq.topic");
        String consumerGroup = m.meta("mq.consumer");
        this.watcher.onUnSubscribe(topic, consumerGroup, s);
        this.unsubscribeDo(topic, consumerGroup, s);
    }

    private void onPublish(Session s, Message m, MqMetasResolver mr) throws IOException {
        if (m == null) {
            return;
        }
        this.watcher.onPublish(m);
        this.routingDo(mr, m);
    }

    private void onUnpublish(Session s, Message m) throws IOException {
        this.watcher.onUnPublish(m);
        this.unRoutingDo(m);
    }

    private void confirmDo(Session s, Message m) throws IOException {
        this.confirmDo(s, m, true, "");
    }

    private void confirmDo(Session s, Message m, boolean isOk, String hint) throws IOException {
        if ((m.isRequest() || m.isSubscribe()) && s.isValid()) {
            s.replyEnd(m, (Entity)new StringEntity(hint).metaPut("mq.confirm", isOk ? "1" : "0"));
        }
    }
}

