/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.noear.folkmq.broker.MqMessageHolder;

public class MqMessageHolderQueue
extends DelayQueue<MqMessageHolder> {
    private final AtomicLong[] _counters = new AtomicLong[9];

    public MqMessageHolderQueue() {
        for (int i = 0; i < this._counters.length; ++i) {
            this._counters[i] = new AtomicLong();
        }
    }

    @Override
    public boolean add(MqMessageHolder mh) {
        this.countAdd(mh);
        return super.add(mh);
    }

    @Override
    public MqMessageHolder poll() {
        MqMessageHolder mh = (MqMessageHolder)super.poll();
        if (mh != null) {
            this.countSub(mh);
        }
        return mh;
    }

    @Override
    public boolean remove(Object o) {
        boolean tmp = super.remove(o);
        if (tmp) {
            this.countSub((MqMessageHolder)o);
        }
        return tmp;
    }

    @Override
    public void clear() {
        super.clear();
        for (AtomicLong l1 : this._counters) {
            l1.set(0L);
        }
    }

    private void countAdd(MqMessageHolder mh) {
        int n = mh.getDistributeCount();
        if (n > 7) {
            this._counters[8].incrementAndGet();
        } else {
            this._counters[n].incrementAndGet();
        }
    }

    private void countSub(MqMessageHolder mh) {
        int n = mh.getDistributeCount();
        if (n > 7) {
            this._counters[8].decrementAndGet();
        } else {
            this._counters[n].decrementAndGet();
        }
    }

    public long countGet(int n) {
        if (n > 7) {
            return this._counters[8].longValue();
        }
        return this._counters[n].longValue();
    }
}

