/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.client;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.noear.folkmq.client.MqClientInternal;
import org.noear.folkmq.client.MqMessageReceived;
import org.noear.folkmq.common.MqMetasResolver;
import org.noear.folkmq.common.MqTopicHelper;
import org.noear.folkmq.common.MqUtils;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;

public class MqMessageReceivedImpl
implements MqMessageReceived {
    private final transient MqClientInternal clientInternal;
    private final transient Message source;
    private final transient Session session;
    private final String sender;
    private final String key;
    private final String tag;
    private final String topic;
    private final String fullTopic;
    private final String consumerGroup;
    private final Date expiration;
    private final boolean broadcast;
    private final boolean sequence;
    private final boolean transaction;
    private final int qos;
    private final int times;
    private boolean replied = false;

    protected boolean isReplied() {
        return this.replied;
    }

    protected void setReplied(boolean replied) {
        this.replied = replied;
    }

    public MqMessageReceivedImpl(MqClientInternal clientInternal, Session session, Message source) {
        this.clientInternal = clientInternal;
        this.session = session;
        this.source = source;
        MqMetasResolver mr = MqUtils.getOf((Entity)source);
        this.sender = mr.getSender((Entity)source);
        this.key = mr.getKey((Entity)source);
        this.tag = mr.getTag((Entity)source);
        this.fullTopic = mr.getTopic((Entity)source);
        this.topic = MqTopicHelper.getTopic(this.fullTopic);
        this.consumerGroup = mr.getConsumerGroup((Entity)source);
        this.qos = mr.getQos((Entity)source);
        this.times = mr.getTimes((Entity)source);
        this.broadcast = mr.isBroadcast((Entity)source);
        this.sequence = mr.isSequence((Entity)source);
        this.transaction = mr.isTransaction((Entity)source);
        long expirationL = mr.getExpiration((Entity)source);
        this.expiration = expirationL == 0L ? null : new Date(expirationL);
    }

    public Message getSource() {
        return this.source;
    }

    @Override
    public String getSender() {
        return this.sender;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public String getFullTopic() {
        return this.fullTopic;
    }

    @Override
    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    @Override
    public byte[] getBody() {
        return this.source.dataAsBytes();
    }

    @Override
    public String getBodyAsString() {
        return this.source.dataAsString();
    }

    @Override
    public int getQos() {
        return this.qos;
    }

    @Override
    public String getAttr(String name) {
        return this.source.meta("!" + name);
    }

    @Override
    public Date getExpiration() {
        return this.expiration;
    }

    @Override
    public boolean isTransaction() {
        return this.transaction;
    }

    @Override
    public boolean isBroadcast() {
        return this.broadcast;
    }

    @Override
    public boolean isSequence() {
        return this.sequence;
    }

    @Override
    public int getTimes() {
        return this.times;
    }

    @Override
    public void acknowledge(boolean isOk) throws IOException {
        this.clientInternal.reply(this.session, this, isOk, null);
    }

    @Override
    public void response(Entity entity) throws IOException {
        this.clientInternal.reply(this.session, this, true, entity);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("MqMessageReceived{");
        buf.append("times='").append(this.times).append("',");
        buf.append("key='").append(this.key).append("',");
        buf.append("tag='").append(this.tag).append("',");
        buf.append("topic='").append(this.topic).append("',");
        buf.append("body='").append(this.getBodyAsString()).append("',");
        for (Map.Entry kv : this.source.metaMap().entrySet()) {
            if (!((String)kv.getKey()).startsWith("!")) continue;
            buf.append((String)kv.getKey()).append("='").append((String)kv.getValue()).append("',");
        }
        buf.setLength(buf.length() - 1);
        buf.append("}");
        return buf.toString();
    }
}

