/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.common;

import org.noear.folkmq.common.MqMetasResolver;
import org.noear.folkmq.common.MqMetasResolverV1;
import org.noear.folkmq.common.MqMetasResolverV2;
import org.noear.folkmq.common.MqMetasResolverV3;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Session;

public class MqUtils {
    private static MqMetasResolver v1 = new MqMetasResolverV1();
    private static MqMetasResolver v2 = new MqMetasResolverV2();
    private static MqMetasResolver v3 = new MqMetasResolverV3();

    public static MqMetasResolver getLast() {
        return v2;
    }

    public static MqMetasResolver getOf(Session s) {
        String ver = s.handshake().paramOrDefault("folkmq-version", "1");
        return MqUtils.resolve(ver);
    }

    public static MqMetasResolver getOf(Entity m) {
        if (m == null) {
            return MqUtils.getLast();
        }
        String ver = m.metaOrDefault("v0", "1");
        return MqUtils.resolve(ver);
    }

    private static MqMetasResolver resolve(String ver) {
        if ("1".equals(ver)) {
            return v1;
        }
        if ("2".equals(ver)) {
            return v2;
        }
        return v3;
    }
}

