/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.noear.socketd.utils.StrUtils;

public class IoUtils {
    public static String transferToString(InputStream ins, String charset) throws IOException {
        if (ins == null) {
            return null;
        }
        ByteArrayOutputStream outs = IoUtils.transferTo(ins, new ByteArrayOutputStream());
        if (StrUtils.isEmpty((String)charset)) {
            return outs.toString();
        }
        return outs.toString(charset);
    }

    public static byte[] transferToBytes(InputStream ins) throws IOException {
        if (ins == null) {
            return null;
        }
        return IoUtils.transferTo(ins, new ByteArrayOutputStream()).toByteArray();
    }

    public static <T extends OutputStream> T transferTo(InputStream ins, T out) throws IOException {
        if (ins == null || out == null) {
            return null;
        }
        int len = 0;
        byte[] buf = new byte[512];
        while ((len = ins.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        return out;
    }

    public static <T extends OutputStream> T transferTo(InputStream ins, T out, long start, long length) throws IOException {
        int len = 0;
        byte[] buf = new byte[512];
        int bufMax = buf.length;
        if (length < (long)bufMax) {
            bufMax = (int)length;
        }
        if (start > 0L) {
            ins.skip(start);
        }
        while ((len = ins.read(buf, 0, bufMax)) != -1) {
            out.write(buf, 0, len);
            if ((long)bufMax <= (length -= (long)len) || (bufMax = (int)length) != 0) continue;
            break;
        }
        return out;
    }

    public static String readFile(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            byte[] bytes;
            byte[] contentBytes = bytes = IoUtils.transferToBytes(input);
            String string = new String(contentBytes, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static void saveFile(File file, String content) throws IOException {
        byte[] contentBytes;
        byte[] bytes = contentBytes = content.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);
             FileOutputStream out = new FileOutputStream(file);){
            IoUtils.transferTo(input, out);
        }
    }
}

