/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.noear.folkmq.utils.PackagingLoop;
import org.noear.folkmq.utils.PackagingWorkHandler;

public class PackagingLoopImpl<Event>
implements PackagingLoop<Event>,
Closeable {
    private long idleInterval = 500L;
    private final long idleInterval_min = 10L;
    private int packetSize = 150;
    private final int packetSize_min = 1;
    private Thread workThread;
    private PackagingWorkHandler<Event> workHandler;
    private Queue<Event> queueLocal = new LinkedBlockingQueue<Event>();
    private boolean isStopped = false;

    public PackagingLoopImpl() {
        this.workThread = new Thread(() -> this.workStartDo(), "Simple task");
        this.workThread.start();
    }

    public PackagingLoopImpl(long idleInterval, int packetSize, PackagingWorkHandler<Event> workHandler) {
        this();
        this.setIdleInterval(idleInterval);
        this.setPacketSize(packetSize);
        this.setWorkHandler(workHandler);
    }

    @Override
    public void setWorkHandler(PackagingWorkHandler<Event> workHandler) {
        this.workHandler = workHandler;
    }

    @Override
    public void add(Event event) {
        try {
            this.queueLocal.add(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void addAll(Collection<Event> events) {
        try {
            this.queueLocal.addAll(events);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public long getIdleInterval() {
        return this.idleInterval;
    }

    @Override
    public void setIdleInterval(long idleInterval) {
        if (idleInterval >= 10L) {
            this.idleInterval = idleInterval;
        }
    }

    @Override
    public void setPacketSize(int packetSize) {
        if (packetSize >= 1) {
            this.packetSize = packetSize;
        }
    }

    private void workStartDo() {
        while (!this.isStopped) {
            try {
                long time_start = System.currentTimeMillis();
                this.workExecDo();
                long time_end = System.currentTimeMillis();
                if (this.getIdleInterval() == 0L) {
                    return;
                }
                if (time_end - time_start >= this.getIdleInterval()) continue;
                Thread.sleep(this.getIdleInterval());
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    private void workExecDo() throws Exception {
        if (this.workHandler == null) {
            return;
        }
        while (true) {
            if (this.isStopped) {
                return;
            }
            ArrayList list = new ArrayList(this.packetSize);
            this.collectDo(list);
            if (list.size() <= 0) break;
            this.workHandler.doWork(list);
        }
    }

    private void collectDo(List<Event> list) {
        int count = 0;
        do {
            if (this.isStopped) {
                return;
            }
            Event event = this.queueLocal.poll();
            if (event == null) break;
            list.add(event);
        } while (++count != this.packetSize);
    }

    @Override
    public void close() throws IOException {
        this.isStopped = true;
    }
}

