/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.solon.integration;

import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.solon.integration.HibernateConfiguration;
import org.noear.solon.Solon;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.util.ResourceUtil;

public class HibernateAdapter {
    protected BeanWrap dsWrap;
    protected Props dsProps;
    protected HibernateConfiguration configuration;
    private SessionFactory sessionFactory;

    public HibernateAdapter(BeanWrap dsWrap) {
        this(dsWrap, Solon.cfg().getProp("jpa"));
    }

    public HibernateAdapter(BeanWrap dsWrap, Props dsProps) {
        this.dsWrap = dsWrap;
        this.dsProps = dsProps;
        DataSource dataSource = this.getDataSource();
        this.configuration = new HibernateConfiguration();
        this.configuration.setDataSource(dataSource);
        this.initConfiguration();
        this.initDo();
    }

    protected DataSource getDataSource() {
        return (DataSource)this.dsWrap.raw();
    }

    public SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.getConfiguration().buildSessionFactory();
        }
        return this.sessionFactory;
    }

    public HibernateConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void initConfiguration() {
        if (ResourceUtil.hasResource(null, (String)"hibernate.cfg.xml")) {
            this.configuration.configure("hibernate.cfg.xml");
        }
        this.getConfiguration().setProperties((Properties)this.dsProps.getProp("properties"));
    }

    protected void initDo() {
        this.dsProps.forEach((k, v) -> {
            if (k instanceof String && v instanceof String) {
                String key = (String)k;
                String valStr = (String)v;
                if (key.startsWith("mappings[") || key.equals("mappings")) {
                    for (String val : valStr.split(",")) {
                        if ((val = val.trim()).length() == 0) continue;
                        this.getConfiguration().addMapping(val);
                    }
                }
            }
        });
    }

    protected void injectTo(VarHolder vh) {
        if (SessionFactory.class.isAssignableFrom(vh.getType())) {
            vh.setValue((Object)this.getSessionFactory());
        }
        if (Configuration.class.isAssignableFrom(vh.getType())) {
            vh.setValue((Object)this.getConfiguration());
        }
        if (EntityManagerFactory.class.isAssignableFrom(vh.getType())) {
            vh.setValue((Object)this.getSessionFactory());
        }
    }
}

