/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.solon.integration;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.solon.integration.HibernateAdapter;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;

public class HibernateAdapterManager {
    private static final Map<String, HibernateAdapter> dbMap = new ConcurrentHashMap<String, HibernateAdapter>();

    public static HibernateAdapter getOnly(String name) {
        return dbMap.get(name);
    }

    public static Map<String, HibernateAdapter> getAll() {
        return Collections.unmodifiableMap(dbMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HibernateAdapter get(BeanWrap bw) {
        HibernateAdapter db = dbMap.get(bw.name());
        if (db == null) {
            Map<String, HibernateAdapter> map = dbMap;
            synchronized (map) {
                db = dbMap.get(bw.name());
                if (db == null) {
                    db = HibernateAdapterManager.buildAdapter(bw);
                    dbMap.put(bw.name(), db);
                    if (bw.typed()) {
                        dbMap.put("", db);
                    }
                }
            }
        }
        return db;
    }

    public static void register(BeanWrap bw) {
        HibernateAdapterManager.get(bw);
    }

    private static HibernateAdapter buildAdapter(BeanWrap bw) {
        HibernateAdapter adapter = Utils.isEmpty((String)bw.name()) ? new HibernateAdapter(bw) : new HibernateAdapter(bw, Solon.cfg().getProp("jpa." + bw.name()));
        return adapter;
    }
}

