/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.solon.integration;

import java.util.Collection;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.context.internal.ThreadLocalSessionContext;
import org.hibernate.solon.integration.JpaTranSessionFactory;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;

public class HibernateConfiguration
extends Configuration {
    public HibernateConfiguration addMapping(String basePackage) {
        if (Utils.isNotEmpty((String)basePackage)) {
            Collection classes = ResourceUtil.scanClasses((String)basePackage);
            for (Class clazz : classes) {
                this.addAnnotatedClass(clazz);
            }
        }
        return this;
    }

    public HibernateConfiguration setDataSource(DataSource dataSource) {
        if (dataSource != null) {
            this.getProperties().put("hibernate.connection.datasource", dataSource);
        }
        return this;
    }

    public HibernateConfiguration setProperties(Properties properties) {
        if (properties != null) {
            properties.entrySet().forEach(obj -> this.getProperties().put(obj.getKey(), obj.getValue()));
        }
        return this;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        this.getProperties().put("hibernate.transaction.coordinator_class", "jdbc");
        this.getProperties().put("hibernate.current_session_context_class", ThreadLocalSessionContext.class.getName());
        SessionFactory sessionFactory = super.buildSessionFactory();
        return new JpaTranSessionFactory(sessionFactory);
    }
}

