/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.solon.integration;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Metamodel;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;
import org.noear.solon.data.tran.TranListener;
import org.noear.solon.data.tran.TranUtils;

public class JpaTranSessionFactory
implements SessionFactory {
    private SessionFactory real;

    public JpaTranSessionFactory(SessionFactory real) {
        this.real = real;
    }

    private <T extends EntityManager> T tranTry(T entityManager) {
        EntityTransaction transaction;
        if (TranUtils.inTrans() && !(transaction = entityManager.getTransaction()).isActive()) {
            transaction.begin();
            TranUtils.listen((TranListener)new TranListener(){

                public void beforeCommit(boolean readOnly) throws Throwable {
                    if (readOnly) {
                        transaction.setRollbackOnly();
                    }
                    transaction.commit();
                }

                public void afterCompletion(int status) {
                    if (status == 1) {
                        transaction.rollback();
                    }
                }
            });
        }
        return entityManager;
    }

    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.real.getSessionFactoryOptions();
    }

    public SessionBuilder withOptions() {
        return this.real.withOptions();
    }

    public Session openSession() throws HibernateException {
        return this.tranTry(this.real.openSession());
    }

    public Session getCurrentSession() throws HibernateException {
        return this.tranTry(this.real.getCurrentSession());
    }

    public StatelessSessionBuilder withStatelessOptions() {
        return this.real.withStatelessOptions();
    }

    public StatelessSession openStatelessSession() {
        return this.real.openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.real.openStatelessSession(connection);
    }

    public Statistics getStatistics() {
        return this.real.getStatistics();
    }

    public void close() throws HibernateException {
        this.real.close();
    }

    public Map<String, Object> getProperties() {
        return this.real.getProperties();
    }

    public boolean isClosed() {
        return this.real.isClosed();
    }

    public Cache getCache() {
        return this.real.getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.real.getPersistenceUnitUtil();
    }

    public void addNamedQuery(String name, Query query) {
        this.real.addNamedQuery(name, query);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.real.unwrap(cls);
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.real.addNamedEntityGraph(graphName, entityGraph);
    }

    public Set getDefinedFilterNames() {
        return this.real.getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.real.getFilterDefinition(filterName);
    }

    public boolean containsFetchProfileDefinition(String name) {
        return this.real.containsFetchProfileDefinition(name);
    }

    public TypeHelper getTypeHelper() {
        return this.real.getTypeHelper();
    }

    public ClassMetadata getClassMetadata(Class entityClass) {
        return this.real.getClassMetadata(entityClass);
    }

    public ClassMetadata getClassMetadata(String entityName) {
        return this.real.getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) {
        return this.real.getCollectionMetadata(roleName);
    }

    public Map<String, ClassMetadata> getAllClassMetadata() {
        return this.real.getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() {
        return this.real.getAllCollectionMetadata();
    }

    public Reference getReference() throws NamingException {
        return this.real.getReference();
    }

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return this.real.findEntityGraphsByType(entityClass);
    }

    public EntityManager createEntityManager() {
        return this.tranTry(this.real.createEntityManager());
    }

    public EntityManager createEntityManager(Map map) {
        return this.tranTry(this.real.createEntityManager(map));
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.tranTry(this.real.createEntityManager(synchronizationType));
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.tranTry(this.real.createEntityManager(synchronizationType, map));
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.real.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.real.getMetamodel();
    }

    public boolean isOpen() {
        return this.real.isOpen();
    }
}

