/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.solon;

import com.fujieid.jap.core.JapUserService;
import com.fujieid.jap.simple.SimpleStrategy;
import com.fujieid.jap.social.SocialStrategy;
import com.fujieid.jap.solon.FixedSocialStrategy;
import com.fujieid.jap.solon.JapProps;
import com.fujieid.jap.solon.http.controller.AccountController;
import com.fujieid.jap.solon.http.controller.MfaController;
import com.fujieid.jap.solon.http.controller.SimpleController;
import com.fujieid.jap.solon.http.controller.SocialController;
import com.fujieid.jap.sso.JapMfa;
import com.fujieid.jap.sso.JapMfaService;
import com.warrenstrange.googleauth.ICredentialRepository;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.AppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class JapInitializer {
    private static final Logger log = LoggerFactory.getLogger(JapInitializer.class);
    @Inject
    JapProps japProperties;
    @Inject
    JapUserService japUserService;
    @Inject
    JapMfaService japMfaService;
    @Inject
    AppContext context;

    @Init
    private void initialize() {
        log.info("Just Auth Plus: ");
        log.info("\tSimple: {}", (Object)(this.japProperties.getSimpleConfig() != null ? "\u5df2\u542f\u7528" : "\u672a\u542f\u7528"));
        log.info("\tSocial: {}", (Object)(this.japProperties.getCredentials() != null ? "\u5df2\u542f\u7528" : "\u672a\u542f\u7528"));
        log.info("\tMfa: {}", (Object)(this.japMfaService != null ? "\u5df2\u542f\u7528" : "\u672a\u542f\u7528"));
        Solon.app().add(this.japProperties.getAccountPath(), AccountController.class);
        if (this.japProperties.getSimpleConfig() != null) {
            this.context.wrapAndPut(SimpleStrategy.class, (Object)new SimpleStrategy(this.japUserService, this.japProperties.getJapConfig()));
            Solon.app().add(this.japProperties.getAuthPath(), SimpleController.class);
        }
        if (this.japProperties.getCredentials() != null) {
            this.context.wrapAndPut(SocialStrategy.class, (Object)new FixedSocialStrategy(this.japUserService, this.japProperties.getJapConfig()));
            Solon.app().add(this.japProperties.getAuthPath(), SocialController.class);
        }
        if (this.japMfaService != null) {
            JapMfa japMfa = new JapMfa((ICredentialRepository)this.japMfaService);
            this.context.wrapAndPut(JapMfa.class, (Object)japMfa);
            Solon.app().add(this.japProperties.getAuthPath(), MfaController.class);
        }
    }
}

