/*
 * Decompiled with CFR 0.152.
 */
package org.noear.jlhttp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServer {
    static final Logger log = LoggerFactory.getLogger(HTTPServer.class);
    public static int MAX_BODY_SIZE = 0x200000;
    public static int MAX_HEADER_SIZE = 8192;
    public static final String[] DATE_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss z", "EEEE, dd-MMM-yy HH:mm:ss z", "EEE MMM d HH:mm:ss yyyy"};
    protected static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    protected static final char[] DAYS = "Sun Mon Tue Wed Thu Fri Sat".toCharArray();
    protected static final char[] MONTHS = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".toCharArray();
    public static final byte[] CRLF = new byte[]{13, 10};
    protected static final int statusesMax = 599;
    protected static final String[] statuses = new String[600];
    private static final String UnknownStatus = "Unknown Status";
    protected static final Map<String, String> contentTypes;
    protected static String[] compressibleContentTypes;
    protected volatile int port;
    protected volatile String host;
    protected volatile int socketTimeout = 10000;
    protected volatile ServerSocketFactory serverSocketFactory;
    protected volatile boolean secure;
    protected volatile Executor executor;
    protected volatile ServerSocket serv;
    protected final Map<String, VirtualHost> hosts = new ConcurrentHashMap<String, VirtualHost>();

    public HTTPServer(int port) {
        this.setPort(port);
        this.addVirtualHost(new VirtualHost(null));
    }

    public HTTPServer(String host, int port) {
        this.setPort(port);
        this.setHost(host);
        this.addVirtualHost(new VirtualHost(null));
    }

    public HTTPServer() {
        this(80);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
        this.secure = factory instanceof SSLServerSocketFactory;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public VirtualHost getVirtualHost(String name) {
        return this.hosts.get(name == null ? "" : name);
    }

    public Set<VirtualHost> getVirtualHosts() {
        return Collections.unmodifiableSet(new HashSet<VirtualHost>(this.hosts.values()));
    }

    public void addVirtualHost(VirtualHost host) {
        String name = host.getName();
        this.hosts.put(name == null ? "" : name, host);
    }

    protected ServerSocket createServerSocket() throws IOException {
        ServerSocket serv = this.serverSocketFactory.createServerSocket();
        serv.setReuseAddress(true);
        InetSocketAddress address = null;
        address = this.host == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.host, this.port);
        serv.bind(address);
        return serv;
    }

    public synchronized void start() throws IOException {
        if (this.serv != null) {
            return;
        }
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        this.serv = this.createServerSocket();
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool();
        }
        for (VirtualHost host : this.getVirtualHosts()) {
            for (String alias : host.getAliases()) {
                this.hosts.put(alias, host);
            }
        }
        new SocketHandlerThread().start();
    }

    public synchronized void stop() {
        try {
            if (this.serv != null) {
                this.serv.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serv = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleConnection(InputStream in, OutputStream out, Socket sock) throws IOException {
        Response resp;
        Request req;
        in = new BufferedInputStream(in, 4096);
        out = new BufferedOutputStream(out, 4096);
        do {
            req = null;
            resp = new Response(out);
            try {
                req = new Request(in, sock);
                this.handleTransaction(req, resp);
            }
            catch (Throwable t) {
                if (req == null) {
                    if (t instanceof IOException && t.getMessage().contains("missing request line")) break;
                    resp.getHeaders().add("Connection", "close");
                    if (t instanceof InterruptedIOException) {
                        resp.sendError(408, "Timeout waiting for client request");
                        break;
                    }
                    resp.sendError(400, "Invalid request: " + t.getMessage());
                    break;
                }
                if (resp.headersSent()) break;
                resp = new Response(out);
                resp.getHeaders().add("Connection", "close");
                resp.sendError(500, "Error processing request: " + t.getMessage());
                break;
            }
            finally {
                resp.close();
            }
            HTTPServer.transfer(req.getBody(), null, -1L);
        } while (!"close".equalsIgnoreCase(req.getHeaders().get("Connection")) && !"close".equalsIgnoreCase(resp.getHeaders().get("Connection")) && req.getVersion().endsWith("1.1"));
    }

    protected void handleTransaction(Request req, Response resp) throws IOException {
        resp.setClientCapabilities(req);
        if (this.preprocessTransaction(req, resp)) {
            this.handleMethod(req, resp);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean preprocessTransaction(Request req, Response resp) throws IOException {
        Headers reqHeaders = req.getHeaders();
        String version = req.getVersion();
        if (version.equals("HTTP/1.1")) {
            if (!reqHeaders.contains("Host")) {
                resp.sendError(400, "Missing required Host header");
                return false;
            }
            String expect = reqHeaders.get("Expect");
            if (expect == null) return true;
            if (expect.equalsIgnoreCase("100-continue")) {
                Response tempResp = new Response(resp.getOutputStream());
                tempResp.sendHeaders(100);
                resp.getOutputStream().flush();
                return true;
            }
            resp.sendError(417);
            return false;
        }
        if (!version.equals("HTTP/1.0") && !version.equals("HTTP/0.9")) {
            resp.sendError(400, "Unknown version: " + version);
            return false;
        }
        String[] stringArray = HTTPServer.splitElements(reqHeaders.get("Connection"), false);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            reqHeaders.remove(token);
            ++n2;
        }
        return true;
    }

    protected void handleMethod(Request req, Response resp) throws IOException {
        String method = req.getMethod();
        if (method.equals("TRACE")) {
            this.handleTrace(req, resp);
        } else {
            this.serve(req, resp);
        }
    }

    public void handleTrace(Request req, Response resp) throws IOException {
        resp.sendHeaders(200, -1L, -1L, null, "message/http", null);
        OutputStream out = resp.getBody();
        out.write(HTTPServer.getBytes("TRACE ", req.getURI().toString(), " ", req.getVersion()));
        out.write(CRLF);
        req.getHeaders().writeTo(out);
        HTTPServer.transfer(req.getBody(), out, -1L);
    }

    protected void serve(Request req, Response resp) throws IOException {
        ContextHandler handler = req.getContext().getHandlers().get("*");
        if (handler == null) {
            resp.sendError(404);
            return;
        }
        handler.serve(req, resp);
    }

    public static void addContentType(String contentType, String ... suffixes) {
        for (String suffix : suffixes) {
            contentTypes.put(suffix.toLowerCase(Locale.US), contentType.toLowerCase(Locale.US));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void addContentTypes(InputStream in) throws IOException {
        try {
            try {
                block4: while (true) {
                    if ((line = HTTPServer.readLine(in).trim()).length() <= 0 || line.charAt(0) == '#') {
                        continue;
                    }
                    tokens = HTTPServer.split(line, " \t", -1);
                    i = 1;
                    while (true) {
                        if (i < tokens.length) ** break;
                        continue block4;
                        HTTPServer.addContentType(tokens[0], new String[]{tokens[i]});
                        ++i;
                    }
                    break;
                }
            }
            catch (EOFException var1_2) {
                in.close();
            }
        }
        catch (Throwable var4_5) {
            in.close();
            throw var4_5;
        }
    }

    public static String getContentType(String path, String def) {
        int dot = path.lastIndexOf(46);
        String type = dot < 0 ? def : contentTypes.get(path.substring(dot + 1).toLowerCase(Locale.US));
        return type != null ? type : def;
    }

    public static String detectLocalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            return "localhost";
        }
    }

    public static List<String[]> parseParamsList(String s) {
        if (s == null || s.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String[]> params = new ArrayList<String[]>(8);
        for (String pair : HTTPServer.split(s, "&", -1)) {
            int pos = pair.indexOf(61);
            String name = pos < 0 ? pair : pair.substring(0, pos);
            String val = pos < 0 ? "" : pair.substring(pos + 1);
            try {
                name = URLDecoder.decode(name.trim(), "UTF-8");
                val = URLDecoder.decode(val.trim(), "UTF-8");
                if (name.length() <= 0) continue;
                params.add(new String[]{name, val});
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return params;
    }

    public static <K, V> Map<K, V> toMap(Collection<? extends Object[]> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(pairs.size());
        for (Object[] objectArray : pairs) {
            if (map.containsKey(objectArray[0])) continue;
            map.put(objectArray[0], objectArray[1]);
        }
        return map;
    }

    public static long[] parseRange(String range, long length) {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        try {
            for (String token : HTTPServer.splitElements(range, false)) {
                long end;
                long start;
                int dash = token.indexOf(45);
                if (dash == 0) {
                    start = length - HTTPServer.parseULong(token.substring(1), 10);
                    end = length - 1L;
                } else if (dash == token.length() - 1) {
                    start = HTTPServer.parseULong(token.substring(0, dash), 10);
                    end = length - 1L;
                } else {
                    start = HTTPServer.parseULong(token.substring(0, dash), 10);
                    end = HTTPServer.parseULong(token.substring(dash + 1), 10);
                }
                if (end < start) {
                    throw new RuntimeException();
                }
                if (start < min) {
                    min = start;
                }
                if (end <= max) continue;
                max = end;
            }
            if (max < 0L) {
                throw new RuntimeException();
            }
            if (max >= length && min < length) {
                max = length - 1L;
            }
            return new long[]{min, max};
        }
        catch (RuntimeException re) {
            return null;
        }
    }

    public static long parseULong(String s, int radix) throws NumberFormatException {
        long val = Long.parseLong(s, radix);
        if (s.charAt(0) == '-' || s.charAt(0) == '+') {
            throw new NumberFormatException("invalid digit: " + s.charAt(0));
        }
        return val;
    }

    public static Date parseDate(String time) {
        for (String pattern : DATE_PATTERNS) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(pattern, Locale.US);
                df.setLenient(false);
                df.setTimeZone(GMT);
                return df.parse(time);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException("invalid date format: " + time);
    }

    public static String formatDate(long time) {
        if (time < -62167392000000L || time > 253402300799999L) {
            throw new IllegalArgumentException("year out of range (0001-9999): " + time);
        }
        char[] s = "DAY, 00 MON 0000 00:00:00 GMT".toCharArray();
        GregorianCalendar cal = new GregorianCalendar(GMT, Locale.US);
        cal.setTimeInMillis(time);
        System.arraycopy(DAYS, 4 * (cal.get(7) - 1), s, 0, 3);
        System.arraycopy(MONTHS, 4 * cal.get(2), s, 8, 3);
        int n = cal.get(5);
        s[5] = (char)(s[5] + n / 10);
        s[6] = (char)(s[6] + n % 10);
        n = cal.get(1);
        s[12] = (char)(s[12] + n / 1000);
        s[13] = (char)(s[13] + n / 100 % 10);
        s[14] = (char)(s[14] + n / 10 % 10);
        s[15] = (char)(s[15] + n % 10);
        n = cal.get(11);
        s[17] = (char)(s[17] + n / 10);
        s[18] = (char)(s[18] + n % 10);
        n = cal.get(12);
        s[20] = (char)(s[20] + n / 10);
        s[21] = (char)(s[21] + n % 10);
        n = cal.get(13);
        s[23] = (char)(s[23] + n / 10);
        s[24] = (char)(s[24] + n % 10);
        return new String(s);
    }

    public static String[] splitElements(String list, boolean lower) {
        return HTTPServer.split(lower && list != null ? list.toLowerCase(Locale.US) : list, ",", -1);
    }

    public static String[] split(String str, String delimiters, int limit) {
        if (str == null) {
            return new String[0];
        }
        ArrayList<String> elements = new ArrayList<String>();
        int len = str.length();
        int start = 0;
        while (start < len) {
            int end;
            int n = end = --limit == 0 ? len : start;
            while (end < len && delimiters.indexOf(str.charAt(end)) < 0) {
                ++end;
            }
            String element = str.substring(start, end).trim();
            if (element.length() > 0) {
                elements.add(element);
            }
            start = end + 1;
        }
        return elements.toArray(new String[0]);
    }

    public static <T> String join(String delim, Iterable<T> items) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = items.iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(it.hasNext() ? delim : "");
        }
        return sb.toString();
    }

    public static String getParentPath(String path) {
        int slash = (path = HTTPServer.trimRight(path, '/')).lastIndexOf(47);
        return slash < 0 ? null : path.substring(0, slash);
    }

    public static String trimRight(String s, char c) {
        int len;
        int end;
        for (end = len = s.length() - 1; end >= 0 && s.charAt(end) == c; --end) {
        }
        return end == len ? s : s.substring(0, end + 1);
    }

    public static String trimLeft(String s, char c) {
        int start;
        int len = s.length();
        for (start = 0; start < len && s.charAt(start) == c; ++start) {
        }
        return start == 0 ? s : s.substring(start);
    }

    public static String trimDuplicates(String s, char c) {
        int start = 0;
        while ((start = s.indexOf(c, start) + 1) > 0) {
            int end;
            for (end = start; end < s.length() && s.charAt(end) == c; ++end) {
            }
            if (end <= start) continue;
            s = s.substring(0, start) + s.substring(end);
        }
        return s;
    }

    public static String toSizeApproxString(long size) {
        double s;
        char[] units = new char[]{' ', 'K', 'M', 'G', 'T', 'P', 'E'};
        int u = 0;
        for (s = (double)size; s >= 1000.0; s /= 1024.0) {
            ++u;
        }
        return String.format(s < 10.0 ? "%.1f%c" : "%.0f%c", s, Character.valueOf(units[u]));
    }

    public static String escapeHTML(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len + 30);
        int start = 0;
        for (int i = 0; i < len; ++i) {
            String ref = null;
            switch (s.charAt(i)) {
                case '&': {
                    ref = "&amp;";
                    break;
                }
                case '>': {
                    ref = "&gt;";
                    break;
                }
                case '<': {
                    ref = "&lt;";
                    break;
                }
                case '\"': {
                    ref = "&quot;";
                    break;
                }
                case '\'': {
                    ref = "&#39;";
                }
            }
            if (ref == null) continue;
            sb.append(s.substring(start, i)).append(ref);
            start = i + 1;
        }
        return start == 0 ? s : sb.append(s.substring(start)).toString();
    }

    public static byte[] getBytes(String ... strings) {
        int n = 0;
        for (String s : strings) {
            n += s.length();
        }
        byte[] b = new byte[n];
        n = 0;
        for (String s : strings) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                b[n++] = (byte)s.charAt(i);
            }
        }
        return b;
    }

    public static void transfer(InputStream in, OutputStream out, long len) throws IOException {
        if (len == 0L || out == null && len < 0L && in.read() < 0) {
            return;
        }
        byte[] buf = new byte[4096];
        while (len != 0L) {
            int count = len < 0L || (long)buf.length < len ? buf.length : (int)len;
            if ((count = in.read(buf, 0, count)) < 0) {
                if (len <= 0L) break;
                throw new IOException("unexpected end of stream");
            }
            if (out != null) {
                out.write(buf, 0, count);
            }
            len -= len > 0L ? (long)count : 0L;
        }
    }

    public static String readToken(InputStream in, int delim, String enc, int maxLength) throws IOException {
        int b;
        int len = 0;
        int count = 0;
        byte[] buf = null;
        while ((b = in.read()) != -1 && b != delim) {
            if (count == len) {
                if (count == maxLength) {
                    throw new IOException("token too large (" + count + ")");
                }
                len = len > 0 ? 2 * len : 256;
                len = maxLength < len ? maxLength : len;
                byte[] expanded = new byte[len];
                if (buf != null) {
                    System.arraycopy(buf, 0, expanded, 0, count);
                }
                buf = expanded;
            }
            buf[count++] = (byte)b;
        }
        if (b < 0 && delim != -1) {
            throw new EOFException("unexpected end of stream");
        }
        if (delim == 10 && count > 0 && buf[count - 1] == 13) {
            --count;
        }
        return count > 0 ? new String(buf, 0, count, enc) : "";
    }

    public static String readLine(InputStream in) throws IOException {
        return HTTPServer.readToken(in, 10, "UTF-8", MAX_HEADER_SIZE);
    }

    public static Headers readHeaders(InputStream in) throws IOException {
        String line;
        Headers headers = new Headers();
        String prevLine = "";
        int count = 0;
        while ((line = HTTPServer.readLine(in)).length() > 0) {
            int separator;
            int start;
            for (start = 0; start < line.length() && Character.isWhitespace(line.charAt(start)); ++start) {
            }
            if (start > 0) {
                line = prevLine + ' ' + line.substring(start);
            }
            if ((separator = line.indexOf(58)) < 0) {
                throw new IOException("invalid header: \"" + line + "\"");
            }
            String name = line.substring(0, separator);
            String value = line.substring(separator + 1).trim();
            headers.add(name, value);
            prevLine = line;
            if (++count <= 100) continue;
            throw new IOException("too many header lines");
        }
        return headers;
    }

    public static boolean match(boolean strong, String[] etags, String etag) {
        if (etag == null || strong && etag.startsWith("W/")) {
            return false;
        }
        for (String e : etags) {
            if (!e.equals("*") && (!e.equals(etag) || strong && e.startsWith("W/"))) continue;
            return true;
        }
        return false;
    }

    static {
        Arrays.fill(statuses, UnknownStatus);
        HTTPServer.statuses[100] = "Continue";
        HTTPServer.statuses[200] = "OK";
        HTTPServer.statuses[204] = "No Content";
        HTTPServer.statuses[206] = "Partial Content";
        HTTPServer.statuses[301] = "Moved Permanently";
        HTTPServer.statuses[302] = "Found";
        HTTPServer.statuses[304] = "Not Modified";
        HTTPServer.statuses[307] = "Temporary Redirect";
        HTTPServer.statuses[400] = "Bad Request";
        HTTPServer.statuses[401] = "Unauthorized";
        HTTPServer.statuses[403] = "Forbidden";
        HTTPServer.statuses[404] = "Not Found";
        HTTPServer.statuses[405] = "Method Not Allowed";
        HTTPServer.statuses[408] = "Request Timeout";
        HTTPServer.statuses[412] = "Precondition Failed";
        HTTPServer.statuses[413] = "Request Entity Too Large";
        HTTPServer.statuses[414] = "Request-URI Too Large";
        HTTPServer.statuses[416] = "Requested Range Not Satisfiable";
        HTTPServer.statuses[417] = "Expectation Failed";
        HTTPServer.statuses[500] = "Internal Server Error";
        HTTPServer.statuses[501] = "Not Implemented";
        HTTPServer.statuses[502] = "Bad Gateway";
        HTTPServer.statuses[503] = "Service Unavailable";
        HTTPServer.statuses[504] = "Gateway Time-out";
        contentTypes = new ConcurrentHashMap<String, String>();
        HTTPServer.addContentType("application/font-woff", "woff");
        HTTPServer.addContentType("application/font-woff2", "woff2");
        HTTPServer.addContentType("application/java-archive", "jar");
        HTTPServer.addContentType("application/javascript", "js");
        HTTPServer.addContentType("application/json", "json");
        HTTPServer.addContentType("application/octet-stream", "exe");
        HTTPServer.addContentType("application/pdf", "pdf");
        HTTPServer.addContentType("application/x-7z-compressed", "7z");
        HTTPServer.addContentType("application/x-compressed", "tgz");
        HTTPServer.addContentType("application/x-gzip", "gz");
        HTTPServer.addContentType("application/x-tar", "tar");
        HTTPServer.addContentType("application/xhtml+xml", "xhtml");
        HTTPServer.addContentType("application/zip", "zip");
        HTTPServer.addContentType("audio/mpeg", "mp3");
        HTTPServer.addContentType("image/gif", "gif");
        HTTPServer.addContentType("image/jpeg", "jpg", "jpeg");
        HTTPServer.addContentType("image/png", "png");
        HTTPServer.addContentType("image/svg+xml", "svg");
        HTTPServer.addContentType("image/x-icon", "ico");
        HTTPServer.addContentType("text/css", "css");
        HTTPServer.addContentType("text/csv", "csv");
        HTTPServer.addContentType("text/html; charset=utf-8", "htm", "html");
        HTTPServer.addContentType("text/plain", "txt", "text", "log");
        HTTPServer.addContentType("text/xml", "xml");
        compressibleContentTypes = new String[]{"text/*", "*/javascript", "*icon", "*+xml", "*/json"};
    }

    protected class SocketHandlerThread
    extends Thread {
        protected SocketHandlerThread() {
        }

        @Override
        public void run() {
            this.setName(this.getClass().getSimpleName() + "-" + HTTPServer.this.port);
            try {
                ServerSocket serv = HTTPServer.this.serv;
                while (serv != null && !serv.isClosed()) {
                    Socket sock = serv.accept();
                    try {
                        HTTPServer.this.executor.execute(() -> this.execute(sock));
                    }
                    catch (RejectedExecutionException e) {
                        this.execute(sock);
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                        this.close(sock);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void close(Socket socket) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(Socket sock) {
            try {
                try {
                    sock.setSoTimeout(HTTPServer.this.socketTimeout);
                    sock.setTcpNoDelay(true);
                    HTTPServer.this.handleConnection(sock.getInputStream(), sock.getOutputStream(), sock);
                }
                finally {
                    try {
                        if (!(sock instanceof SSLSocket)) {
                            sock.shutdownOutput();
                            HTTPServer.transfer(sock.getInputStream(), null, -1L);
                        }
                    }
                    finally {
                        sock.close();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class Response
    implements Closeable {
        protected OutputStream out;
        protected OutputStream encodedOut;
        protected Headers headers;
        protected boolean discardBody;
        protected int state;
        protected Request req;

        public Response(OutputStream out) {
            this.out = out;
            this.headers = new Headers();
        }

        public void setDiscardBody(boolean discardBody) {
            this.discardBody = discardBody;
        }

        public void setClientCapabilities(Request req) {
            this.req = req;
        }

        public Headers getHeaders() {
            return this.headers;
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public boolean headersSent() {
            return this.state == 1;
        }

        public OutputStream getBody() throws IOException {
            if (this.encodedOut != null || this.discardBody) {
                return this.encodedOut;
            }
            List<String> te = Arrays.asList(HTTPServer.splitElements(this.headers.get("Transfer-Encoding"), true));
            this.encodedOut = new ResponseOutputStream(this.out);
            if (te.contains("chunked")) {
                this.encodedOut = new ChunkedOutputStream(this.encodedOut);
            }
            return this.encodedOut;
        }

        @Override
        public void close() throws IOException {
            this.state = -1;
            if (this.encodedOut != null) {
                this.encodedOut.close();
            }
            this.out.flush();
        }

        public void flush() throws IOException {
            if (this.encodedOut != null) {
                this.encodedOut.flush();
            }
            this.out.flush();
        }

        public void sendHeaders(int status) throws IOException {
            if (this.headersSent()) {
                throw new IOException("headers were already sent");
            }
            if (!this.headers.contains("Date")) {
                this.headers.add("Date", HTTPServer.formatDate(System.currentTimeMillis()));
            }
            if (status < 0 || status > 599) {
                status = 0;
            }
            this.out.write(HTTPServer.getBytes("HTTP/1.1 ", Integer.toString(status), " ", statuses[status]));
            this.out.write(CRLF);
            this.headers.writeTo(this.out);
            this.state = 1;
        }

        public void sendHeaders(int status, long length, long lastModified, String etag, String contentType, long[] range) throws IOException {
            String ct;
            if (range != null) {
                this.headers.add("Content-Range", "bytes " + range[0] + "-" + range[1] + "/" + (length >= 0L ? Long.valueOf(length) : "*"));
                length = range[1] - range[0] + 1L;
                if (status == 200) {
                    status = 206;
                }
            }
            if ((ct = this.headers.get("Content-Type")) == null) {
                ct = contentType != null ? contentType : "application/octet-stream";
                this.headers.add("Content-Type", ct);
            } else if (contentType != null) {
                ct = contentType;
                this.headers.replace("Content-Type", ct);
            }
            if (!this.headers.contains("Content-Length") && !this.headers.contains("Transfer-Encoding")) {
                boolean modern;
                boolean bl = modern = this.req != null && this.req.getVersion().endsWith("1.1");
                if (length < 0L && modern) {
                    this.headers.replace("Transfer-Encoding", "chunked");
                } else if (length >= 0L) {
                    this.headers.replace("Content-Length", Long.toString(length));
                }
            }
            if (!this.headers.contains("Vary")) {
                this.headers.add("Vary", "Accept-Encoding");
            }
            if (lastModified > 0L && !this.headers.contains("Last-Modified")) {
                this.headers.add("Last-Modified", HTTPServer.formatDate(Math.min(lastModified, System.currentTimeMillis())));
            }
            if (etag != null && !this.headers.contains("ETag")) {
                this.headers.add("ETag", etag);
            }
            if (this.req != null && "close".equalsIgnoreCase(this.req.getHeaders().get("Connection")) && !this.headers.contains("Connection")) {
                this.headers.add("Connection", "close");
            }
            this.sendHeaders(status);
        }

        public void send(int status, String text) throws IOException {
            byte[] content = text.getBytes("UTF-8");
            this.sendHeaders(status, content.length, -1L, "W/\"" + Integer.toHexString(text.hashCode()) + "\"", "text/html; charset=utf-8", null);
            OutputStream out = this.getBody();
            if (out != null) {
                out.write(content);
            }
        }

        public void sendError(int status, String text) throws IOException {
            this.send(status, String.format("<!DOCTYPE html>%n<html>%n<head><title>%d %s</title></head>%n<body><h1>%d %s</h1>%n<p>%s</p>%n</body></html>", status, statuses[status], status, statuses[status], HTTPServer.escapeHTML(text)));
        }

        public void sendError(int status) throws IOException {
            String text = status < 400 ? ":)" : "sorry it didn't work out :(";
            this.sendError(status, text);
        }

        public void sendBody(InputStream body, long length, long[] range) throws IOException {
            OutputStream out = this.getBody();
            if (out != null) {
                if (range != null) {
                    long skip;
                    length = range[1] - range[0] + 1L;
                    for (long offset = range[0]; offset > 0L; offset -= skip) {
                        skip = body.skip(offset);
                        if (skip != 0L) continue;
                        throw new IOException("can't skip to " + range[0]);
                    }
                }
                HTTPServer.transfer(body, out, length);
            }
        }

        public void redirect(String url, boolean permanent) throws IOException {
            try {
                url = new URI(url).toASCIIString();
            }
            catch (URISyntaxException e) {
                throw new IOException("malformed URL: " + url);
            }
            this.headers.add("Location", url);
            if (permanent) {
                this.sendError(301, "Permanently moved to " + url);
            } else {
                this.sendError(302, "Temporarily moved to " + url);
            }
        }
    }

    public class Request {
        protected String method;
        protected URI uri;
        protected URL baseURL;
        protected String version;
        protected Headers headers;
        protected InputStream body;
        protected Socket sock;
        protected Map<String, String> params;
        protected VirtualHost host;
        protected VirtualHost.ContextInfo context;
        private List<String[]> _paramsList;

        public Request(InputStream in, Socket sock) throws IOException {
            this.sock = sock;
            this.readRequestLine(in);
            this.headers = HTTPServer.readHeaders(in);
            String header = this.headers.get("Transfer-Encoding");
            if (header != null && !header.toLowerCase(Locale.US).equals("identity")) {
                this.body = Arrays.asList(HTTPServer.splitElements(header, true)).contains("chunked") ? new ChunkedInputStream(in, this.headers) : in;
            } else {
                header = this.headers.get("Content-Length");
                long len = header == null ? 0L : HTTPServer.parseULong(header, 10);
                this.body = new LimitedInputStream(in, len, false);
            }
        }

        public String getMethod() {
            return this.method;
        }

        public URI getURI() {
            return this.uri;
        }

        public String getVersion() {
            return this.version;
        }

        public Headers getHeaders() {
            return this.headers;
        }

        public InputStream getBody() {
            return this.body;
        }

        public Socket getSocket() {
            return this.sock;
        }

        public String getPath() {
            return this.uri.getPath();
        }

        public void setPath(String path) {
            try {
                this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), HTTPServer.trimDuplicates(path, '/'), this.uri.getQuery(), this.uri.getFragment());
                this.context = null;
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException("error setting path", use);
            }
        }

        public URL getBaseURL() {
            int pos;
            if (this.baseURL != null) {
                return this.baseURL;
            }
            String host = this.uri.getHost();
            if (host == null && (host = this.headers.get("Host")) == null) {
                host = HTTPServer.detectLocalHostName();
            }
            host = (pos = host.indexOf(58)) < 0 ? host : host.substring(0, pos);
            try {
                this.baseURL = new URL(HTTPServer.this.secure ? "https" : "http", host, HTTPServer.this.port, "");
                return this.baseURL;
            }
            catch (MalformedURLException mue) {
                return null;
            }
        }

        public List<String[]> getParamsList() throws IOException {
            if (this._paramsList == null) {
                List<String[]> queryParams = HTTPServer.parseParamsList(this.uri.getRawQuery());
                List<Object> bodyParams = Collections.emptyList();
                String ct = this.headers.get("Content-Type");
                if (ct != null && ct.toLowerCase(Locale.US).startsWith("application/x-www-form-urlencoded")) {
                    bodyParams = HTTPServer.parseParamsList(HTTPServer.readToken(this.body, -1, "UTF-8", MAX_BODY_SIZE));
                }
                this._paramsList = new ArrayList<String[]>();
                if (!queryParams.isEmpty()) {
                    this._paramsList.addAll(queryParams);
                }
                if (!bodyParams.isEmpty()) {
                    this._paramsList.addAll(bodyParams);
                }
            }
            return this._paramsList;
        }

        public Map<String, String> getParams() throws IOException {
            if (this.params == null) {
                this.params = HTTPServer.toMap(this.getParamsList());
            }
            return this.params;
        }

        public long[] getRange(long length) {
            String header = this.headers.get("Range");
            return header == null || !header.startsWith("bytes=") ? null : HTTPServer.parseRange(header.substring(6), length);
        }

        protected void readRequestLine(InputStream in) throws IOException {
            String line;
            try {
                while ((line = HTTPServer.readLine(in)).length() == 0) {
                }
            }
            catch (IOException ioe) {
                throw new IOException("missing request line");
            }
            String[] tokens = HTTPServer.split(line, " ", -1);
            if (tokens.length != 3) {
                throw new IOException("invalid request line: \"" + line + "\"");
            }
            try {
                this.method = tokens[0];
                this.uri = new URI(tokens[1]);
                this.version = tokens[2];
            }
            catch (URISyntaxException use) {
                throw new IOException("invalid URI: " + use.getMessage());
            }
        }

        public VirtualHost getVirtualHost() {
            return this.host != null ? this.host : ((this.host = HTTPServer.this.getVirtualHost(this.getBaseURL().getHost())) != null ? this.host : (this.host = HTTPServer.this.getVirtualHost(null)));
        }

        public VirtualHost.ContextInfo getContext() {
            return this.context != null ? this.context : (this.context = this.getVirtualHost().getContext(this.getPath()));
        }
    }

    public static class Headers
    implements Iterable<Header> {
        protected Header[] headers = new Header[12];
        protected int count;

        public int size() {
            return this.count;
        }

        public String get(String name) {
            for (int i = 0; i < this.count; ++i) {
                if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
                return this.headers[i].getValue();
            }
            return null;
        }

        public Date getDate(String name) {
            try {
                String header = this.get(name);
                return header == null ? null : HTTPServer.parseDate(header);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        public boolean contains(String name) {
            return this.get(name) != null;
        }

        public void add(String name, String value) {
            Header header = new Header(name, value);
            if (this.count == this.headers.length) {
                Header[] expanded = new Header[2 * this.count];
                System.arraycopy(this.headers, 0, expanded, 0, this.count);
                this.headers = expanded;
            }
            this.headers[this.count++] = header;
        }

        public void addAll(Headers headers) {
            for (Header header : headers) {
                this.add(header.getName(), header.getValue());
            }
        }

        public Header replace(String name, String value) {
            for (int i = 0; i < this.count; ++i) {
                if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
                Header prev = this.headers[i];
                this.headers[i] = new Header(name, value);
                return prev;
            }
            this.add(name, value);
            return null;
        }

        public void remove(String name) {
            int j = 0;
            for (int i = 0; i < this.count; ++i) {
                if (this.headers[i].getName().equalsIgnoreCase(name)) continue;
                this.headers[j++] = this.headers[i];
            }
            while (this.count > j) {
                this.headers[--this.count] = null;
            }
        }

        public void writeTo(OutputStream out) throws IOException {
            for (int i = 0; i < this.count; ++i) {
                out.write(HTTPServer.getBytes(this.headers[i].getName(), ": ", this.headers[i].getValue()));
                out.write(CRLF);
            }
            out.write(CRLF);
        }

        public Map<String, String> getParams(String name) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            for (String param : HTTPServer.split(this.get(name), ";", -1)) {
                String[] pair = HTTPServer.split(param, "=", 2);
                String val = pair.length == 1 ? "" : HTTPServer.trimLeft(HTTPServer.trimRight(pair[1], '\"'), '\"');
                params.put(pair[0], val);
            }
            return params;
        }

        @Override
        public Iterator<Header> iterator() {
            return Arrays.asList(this.headers).subList(0, this.count).iterator();
        }
    }

    public static class Header {
        protected final String name;
        protected final String value;

        public Header(String name, String value) {
            this.name = name.trim();
            this.value = value.trim();
            if (this.name.length() == 0) {
                throw new IllegalArgumentException("name cannot be empty");
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static interface ContextHandler {
        public void serve(Request var1, Response var2) throws IOException;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Context {
        public String value();

        public String[] methods() default {"GET"};
    }

    public static class VirtualHost {
        protected final String name;
        protected final Set<String> aliases = new CopyOnWriteArraySet<String>();
        protected volatile String directoryIndex = "index.html";
        protected volatile boolean allowGeneratedIndex;
        protected final Set<String> methods = new CopyOnWriteArraySet<String>();
        protected final ContextInfo emptyContext = new ContextInfo(null);
        protected final ConcurrentMap<String, ContextInfo> contexts = new ConcurrentHashMap<String, ContextInfo>();

        public VirtualHost(String name) {
            this.name = name;
            this.contexts.put("*", new ContextInfo(null));
        }

        public String getName() {
            return this.name;
        }

        public void addAlias(String alias) {
            this.aliases.add(alias);
        }

        public Set<String> getAliases() {
            return Collections.unmodifiableSet(this.aliases);
        }

        public void setDirectoryIndex(String directoryIndex) {
            this.directoryIndex = directoryIndex;
        }

        public String getDirectoryIndex() {
            return this.directoryIndex;
        }

        public void setAllowGeneratedIndex(boolean allowed) {
            this.allowGeneratedIndex = allowed;
        }

        public boolean isAllowGeneratedIndex() {
            return this.allowGeneratedIndex;
        }

        public Set<String> getMethods() {
            return this.methods;
        }

        public ContextInfo getContext(String path) {
            path = HTTPServer.trimRight(path, '/');
            while (path != null) {
                ContextInfo info = (ContextInfo)this.contexts.get(path);
                if (info != null) {
                    return info;
                }
                path = HTTPServer.getParentPath(path);
            }
            return this.emptyContext;
        }

        public void addContext(String path, ContextHandler handler, String ... methods) {
            ContextInfo info;
            if (path == null || !path.startsWith("/") && !path.equals("*")) {
                throw new IllegalArgumentException("invalid path: " + path);
            }
            ContextInfo existing = this.contexts.putIfAbsent(path = HTTPServer.trimRight(path, '/'), info = new ContextInfo(path));
            info = existing != null ? existing : info;
            info.addHandler(handler, methods);
        }

        public class ContextInfo {
            protected final String path;
            protected final Map<String, ContextHandler> handlers = new ConcurrentHashMap<String, ContextHandler>(2);

            public ContextInfo(String path) {
                this.path = path;
            }

            public String getPath() {
                return this.path;
            }

            public Map<String, ContextHandler> getHandlers() {
                return this.handlers;
            }

            public void addHandler(ContextHandler handler, String ... methods) {
                if (methods.length == 0) {
                    methods = new String[]{"GET"};
                }
                for (String method : methods) {
                    this.handlers.put(method, handler);
                    VirtualHost.this.methods.add(method);
                }
            }
        }
    }

    public static class MultipartIterator
    implements Iterator<Part> {
        protected final MultipartInputStream in;
        protected boolean next;

        public MultipartIterator(Request req) throws IOException {
            Map<String, String> ct = req.getHeaders().getParams("Content-Type");
            if (!ct.containsKey("multipart/form-data")) {
                throw new IllegalArgumentException("Content-Type is not multipart/form-data");
            }
            String boundary = ct.get("boundary");
            if (boundary == null) {
                throw new IllegalArgumentException("Content-Type is missing boundary");
            }
            this.in = new MultipartInputStream(req.getBody(), HTTPServer.getBytes(boundary));
        }

        @Override
        public boolean hasNext() {
            try {
                return this.next || (this.next = this.in.nextPart());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public Part next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.next = false;
            Part p = new Part();
            try {
                p.headers = HTTPServer.readHeaders(this.in);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            Map<String, String> cd = p.headers.getParams("Content-Disposition");
            p.name = cd.get("name");
            p.filename = cd.get("filename");
            p.body = this.in;
            return p;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public static class Part {
            public String name;
            public String filename;
            public Headers headers;
            public InputStream body;

            public String getName() {
                return this.name;
            }

            public String getFilename() {
                return this.filename;
            }

            public Headers getHeaders() {
                return this.headers;
            }

            public InputStream getBody() {
                return this.body;
            }

            public String getString() throws IOException {
                String charset = this.headers.getParams("Content-Type").get("charset");
                return HTTPServer.readToken(this.body, -1, charset == null ? "UTF-8" : charset, MAX_BODY_SIZE);
            }
        }
    }

    public static class MultipartInputStream
    extends FilterInputStream {
        protected final byte[] boundary;
        protected final byte[] buf = new byte[4096];
        protected int head;
        protected int tail;
        protected int end;
        protected int len;
        protected int state;

        protected MultipartInputStream(InputStream in, byte[] boundary) {
            super(in);
            int len = boundary.length;
            if (len == 0 || len > 70) {
                throw new IllegalArgumentException("invalid boundary length");
            }
            this.boundary = new byte[len + 4];
            System.arraycopy(CRLF, 0, this.boundary, 0, 2);
            this.boundary[3] = 45;
            this.boundary[2] = 45;
            System.arraycopy(boundary, 0, this.boundary, 4, len);
        }

        @Override
        public int read() throws IOException {
            if (!this.fill()) {
                return -1;
            }
            return this.buf[this.head++] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (!this.fill()) {
                return -1;
            }
            len = Math.min(this.tail - this.head, len);
            System.arraycopy(this.buf, this.head, b, off, len);
            this.head += len;
            return len;
        }

        @Override
        public long skip(long len) throws IOException {
            if (len <= 0L || !this.fill()) {
                return 0L;
            }
            len = Math.min((long)(this.tail - this.head), len);
            this.head = (int)((long)this.head + len);
            return len;
        }

        @Override
        public int available() throws IOException {
            return this.tail - this.head;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        public boolean nextPart() throws IOException {
            while (this.skip(this.buf.length) != 0L) {
            }
            this.head = this.tail += this.len;
            this.state |= 1;
            if (this.state >= 8) {
                this.state |= 0x10;
                return false;
            }
            this.findBoundary();
            return true;
        }

        protected boolean fill() throws IOException {
            int read;
            if (this.head != this.tail) {
                return true;
            }
            if (this.tail > this.buf.length - 256) {
                System.arraycopy(this.buf, this.tail, this.buf, 0, this.end -= this.tail);
                this.tail = 0;
                this.head = 0;
            }
            do {
                if ((read = super.read(this.buf, this.end, this.buf.length - this.end)) < 0) {
                    this.state |= 4;
                } else {
                    this.end += read;
                }
                this.findBoundary();
            } while (read > 0 && this.tail == this.head && this.len == 0);
            if (this.tail != 0) {
                this.state |= 1;
            }
            if (this.state < 8 && this.len > 0) {
                this.state |= 2;
            }
            if ((this.state & 6) == 4 || this.len == 0 && ((this.state & 0xFC) == 4 || read == 0 && this.tail == this.head)) {
                throw new IOException("missing boundary");
            }
            if (this.state >= 16) {
                this.tail = this.end;
            }
            return this.tail > this.head;
        }

        protected void findBoundary() throws IOException {
            this.len = 0;
            int off = this.tail - ((this.state & 1) != 0 || this.buf[0] != 45 ? 0 : 2);
            int end = this.end;
            while (this.tail < end) {
                int j;
                for (j = this.tail; j < end && j - off < this.boundary.length && this.buf[j] == this.boundary[j - off]; ++j) {
                }
                if (j + 1 >= end) {
                    return;
                }
                if (j - off == this.boundary.length) {
                    if (this.buf[j] == 45 && this.buf[j + 1] == 45) {
                        j += 2;
                        this.state |= 8;
                    }
                    while (j < end && (this.buf[j] == 32 || this.buf[j] == 9)) {
                        ++j;
                    }
                    if (j + 1 < end && this.buf[j] == 13 && this.buf[j + 1] == 10) {
                        this.len = j - this.tail + 2;
                    } else {
                        if (j + 1 < end || (this.state & 4) != 0 && j + 1 == end) {
                            throw new IOException("boundary must end with CRLF");
                        }
                        if ((this.state & 4) != 0) {
                            this.len = j - this.tail;
                        }
                    }
                    return;
                }
                off = ++this.tail;
            }
        }
    }

    public static class ResponseOutputStream
    extends FilterOutputStream {
        public ResponseOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }
    }

    public static class ChunkedOutputStream
    extends FilterOutputStream {
        protected int state;

        public ChunkedOutputStream(OutputStream out) {
            super(out);
            if (out == null) {
                throw new NullPointerException("output stream is null");
            }
        }

        protected void initChunk(long size) throws IOException {
            if (size < 0L) {
                throw new IllegalArgumentException("invalid size: " + size);
            }
            if (this.state > 0) {
                this.out.write(CRLF);
            } else if (this.state == 0) {
                this.state = 1;
            } else {
                throw new IOException("chunked stream has already ended");
            }
            this.out.write(HTTPServer.getBytes(Long.toHexString(size)));
            this.out.write(CRLF);
        }

        public void writeTrailingChunk(Headers headers) throws IOException {
            this.initChunk(0L);
            if (headers == null) {
                this.out.write(CRLF);
            } else {
                headers.writeTo(this.out);
            }
            this.state = -1;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                this.initChunk(len);
            }
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this.state > -1) {
                this.writeTrailingChunk(null);
            }
            super.close();
        }
    }

    public static class ChunkedInputStream
    extends LimitedInputStream {
        protected Headers headers;
        protected boolean initialized;

        public ChunkedInputStream(InputStream in, Headers headers) {
            super(in, 0L, true);
            this.headers = headers;
        }

        @Override
        public int read() throws IOException {
            return this.limit <= 0L && this.initChunk() < 0L ? -1 : super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.limit <= 0L && this.initChunk() < 0L ? -1 : super.read(b, off, len);
        }

        protected long initChunk() throws IOException {
            if (this.limit == 0L) {
                if (this.initialized && HTTPServer.readLine(this.in).length() > 0) {
                    throw new IOException("chunk data must end with CRLF");
                }
                this.initialized = true;
                this.limit = ChunkedInputStream.parseChunkSize(HTTPServer.readLine(this.in));
                if (this.limit == 0L) {
                    this.limit = -1L;
                    Headers trailingHeaders = HTTPServer.readHeaders(this.in);
                    if (this.headers != null) {
                        this.headers.addAll(trailingHeaders);
                    }
                }
            }
            return this.limit;
        }

        protected static long parseChunkSize(String line) throws IllegalArgumentException {
            int pos = line.indexOf(59);
            line = pos < 0 ? line : line.substring(0, pos);
            try {
                return HTTPServer.parseULong(line, 16);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid chunk size line: \"" + line + "\"");
            }
        }
    }

    public static class LimitedInputStream
    extends FilterInputStream {
        protected long limit;
        protected boolean prematureEndException;

        public LimitedInputStream(InputStream in, long limit, boolean prematureEndException) {
            super(in);
            if (in == null) {
                throw new NullPointerException("input stream is null");
            }
            this.limit = limit < 0L ? 0L : limit;
            this.prematureEndException = prematureEndException;
        }

        @Override
        public int read() throws IOException {
            int res;
            int n = res = this.limit == 0L ? -1 : this.in.read();
            if (res < 0 && this.limit > 0L && this.prematureEndException) {
                throw new IOException("unexpected end of stream");
            }
            this.limit = res < 0 ? 0L : this.limit - 1L;
            return res;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int res;
            int n = this.limit == 0L ? -1 : (res = this.in.read(b, off, (long)len > this.limit ? (int)this.limit : len));
            if (res < 0 && this.limit > 0L && this.prematureEndException) {
                throw new IOException("unexpected end of stream");
            }
            this.limit = res < 0 ? 0L : this.limit - (long)res;
            return res;
        }

        @Override
        public long skip(long len) throws IOException {
            long res = this.in.skip(len > this.limit ? this.limit : len);
            this.limit -= res;
            return res;
        }

        @Override
        public int available() throws IOException {
            int res = this.in.available();
            return (long)res > this.limit ? (int)this.limit : res;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void close() {
            this.limit = 0L;
        }
    }
}

