/*
 * Decompiled with CFR 0.152.
 */
package org.noear.liquor.eval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.noear.liquor.eval.ParamSpec;

public class CodeSpec {
    private final String code;
    private List<String> imports = new ArrayList<String>();
    private Map.Entry<String, Class<?>>[] parameters;
    private Class<?> returnType;
    private boolean cached = true;

    public CodeSpec(String code) {
        this.code = code;
    }

    public CodeSpec cached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public CodeSpec imports(Class<?> ... imports) {
        for (Class<?> imp : imports) {
            this.imports.add(imp.getCanonicalName());
        }
        return this;
    }

    public CodeSpec imports(String ... imports) {
        for (String imp : imports) {
            this.imports.add(imp);
        }
        return this;
    }

    public CodeSpec parameters(Map.Entry<String, Class<?>> ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public CodeSpec returnType(Class<?> returnType) {
        this.returnType = returnType;
        return this;
    }

    public Object[] bind(Map<String, Object> context) {
        assert (context != null);
        this.parameters = new ParamSpec[context.size()];
        Object[] args = new Object[context.size()];
        int idx = 0;
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            this.parameters[idx] = new ParamSpec(entry.getKey(), entry.getValue().getClass());
            args[idx] = entry.getValue();
            ++idx;
        }
        return args;
    }

    public boolean isCached() {
        return this.cached;
    }

    public String getCode() {
        return this.code;
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    public Map.Entry<String, Class<?>>[] getParameters() {
        return this.parameters;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    private boolean deepEquals(Map.Entry<String, Class<?>>[] a, Map.Entry<String, Class<?>>[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Objects.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CodeSpec)) {
            return false;
        }
        CodeSpec codeSpec = (CodeSpec)o;
        return Objects.equals(this.code, codeSpec.code) && this.deepEquals(this.parameters, codeSpec.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.code, Arrays.hashCode(this.parameters));
    }
}

