/*
 * Decompiled with CFR 0.152.
 */
package org.noear.liquor.eval.jsr223;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.noear.liquor.eval.CodeSpec;
import org.noear.liquor.eval.Scripts;
import org.noear.liquor.eval.jsr223.LiquorScriptEngineFactory;

public class LiquorScriptEngine
extends AbstractScriptEngine {
    private LiquorScriptEngineFactory factory;

    public LiquorScriptEngine(LiquorScriptEngineFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        SimpleBindings bindings = new SimpleBindings();
        bindings.putAll(this.getBindings(200));
        if (context != null) {
            bindings.putAll(context.getBindings(200));
        }
        bindings.putAll(this.getBindings(100));
        if (context != null) {
            bindings.putAll(context.getBindings(100));
        }
        try {
            CodeSpec codeSpec = new CodeSpec(script);
            if (script.contains("return ")) {
                codeSpec.returnType(Object.class);
            }
            if (bindings.isEmpty()) {
                return Scripts.eval(codeSpec);
            }
            return Scripts.eval(codeSpec.parameters(bindings), (Map<String, Object>)bindings);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        StringBuilder buf = new StringBuilder();
        try (BufferedReader reader1 = new BufferedReader(reader);){
            String line;
            while ((line = reader1.readLine()) != null) {
                buf.append(line).append(System.lineSeparator());
            }
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return this.eval(buf.toString(), context);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }
}

