/*
 * Decompiled with CFR 0.152.
 */
package org.noear.liquor.eval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.noear.liquor.eval.ParamSpec;

public class CodeSpec {
    private final String code;
    private final List<String> imports = new ArrayList<String>();
    private final List<ParamSpec> parameters = new ArrayList<ParamSpec>();
    private Class<?> returnType;
    private boolean cached = true;

    public CodeSpec(String code) {
        this.code = code;
    }

    public CodeSpec cached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public CodeSpec imports(Class<?> ... imports) {
        for (Class<?> imp : imports) {
            this.imports.add(imp.getCanonicalName());
        }
        return this;
    }

    public CodeSpec imports(String ... imports) {
        for (String imp : imports) {
            this.imports.add(imp);
        }
        return this;
    }

    public CodeSpec parameters(ParamSpec ... params) {
        this.parameters.addAll(Arrays.asList(params));
        return this;
    }

    public CodeSpec parameters(Map<String, Object> params) {
        assert (params != null);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() instanceof Class) {
                this.parameters.add(new ParamSpec(entry.getKey(), (Class)entry.getValue()));
                continue;
            }
            this.parameters.add(new ParamSpec(entry.getKey(), entry.getValue().getClass()));
        }
        Collections.sort(this.parameters);
        return this;
    }

    public CodeSpec returnType(Class<?> returnType) {
        this.returnType = returnType;
        return this;
    }

    public boolean isCached() {
        return this.cached;
    }

    public String getCode() {
        return this.code;
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    public Collection<ParamSpec> getParameters() {
        return this.parameters;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CodeSpec)) {
            return false;
        }
        CodeSpec codeSpec = (CodeSpec)o;
        return Objects.equals(this.code, codeSpec.code) && Objects.equals(this.parameters, codeSpec.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.parameters);
    }
}

