/*
 * Decompiled with CFR 0.152.
 */
package org.noear.liquor.eval.jsr223;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.noear.liquor.eval.jsr223.LiquorScriptEngine;

public class LiquorScriptEngineFactory
implements ScriptEngineFactory {
    private static final List<String> names = LiquorScriptEngineFactory.immutableList("liquor", "Liquor", "java", "Java");
    private static final List<String> mimeTypes = LiquorScriptEngineFactory.immutableList("text/x-java-source");
    private static final List<String> extensions = LiquorScriptEngineFactory.immutableList("java");

    @Override
    public String getEngineName() {
        return (String)this.getParameter("javax.script.engine");
    }

    @Override
    public String getEngineVersion() {
        return (String)this.getParameter("javax.script.engine_version");
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getLanguageName() {
        return (String)this.getParameter("javax.script.language");
    }

    @Override
    public String getLanguageVersion() {
        return (String)this.getParameter("javax.script.language_version");
    }

    @Override
    public Object getParameter(String key) {
        switch (key) {
            case "javax.script.name": {
                return "java";
            }
            case "javax.script.engine": {
                return "Noear Liquor";
            }
            case "javax.script.engine_version": {
                return "1.5.5";
            }
            case "javax.script.language": {
                return "java";
            }
            case "javax.script.language_version": {
                return "Java - " + System.getProperty("java.specification.version");
            }
            case "THREADING": {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        StringBuilder sb = new StringBuilder().append(obj).append('.').append(method).append('(');
        int len = args.length;
        if (len > 0) {
            sb.append(args[0]);
        }
        for (int i = 1; i < len; ++i) {
            sb.append(',').append(args[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "System.out.println(" + toDisplay + ")";
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        for (String statement : statements) {
            sb.append(statement).append(';');
        }
        return sb.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new LiquorScriptEngine(this);
    }

    private static List<String> immutableList(String ... elements) {
        return Collections.unmodifiableList(Arrays.asList(elements));
    }
}

