/*
 * Decompiled with CFR 0.152.
 */
package org.noear.liquor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.noear.liquor.DynamicClassLoader;
import org.noear.liquor.DynamicCompilerException;
import org.noear.liquor.DynamicJavaFileManager;
import org.noear.liquor.StringSource;

public class DynamicCompiler {
    private final JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
    private final StandardJavaFileManager standardFileManager;
    private final List<String> options = new ArrayList<String>();
    private final ClassLoader parentClassLoader;
    private final Collection<JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>();
    private final List<Diagnostic<? extends JavaFileObject>> errors = new ArrayList<Diagnostic<? extends JavaFileObject>>();
    private final List<Diagnostic<? extends JavaFileObject>> warnings = new ArrayList<Diagnostic<? extends JavaFileObject>>();
    private DynamicClassLoader dynamicClassLoader;

    public DynamicCompiler() {
        this(null);
    }

    public DynamicCompiler(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (this.javaCompiler == null) {
            throw new IllegalStateException("Can not load JavaCompiler from javax.tools.ToolProvider#getSystemJavaCompiler(), please confirm the application running in JDK not JRE.");
        }
        this.standardFileManager = this.javaCompiler.getStandardFileManager(null, null, null);
        this.options.add("-Xlint:unchecked");
        this.options.add("-g");
        this.options.add("-XDuseUnsharedTable");
        this.parentClassLoader = classLoader;
    }

    public DynamicClassLoader getClassLoader() {
        if (this.dynamicClassLoader == null) {
            this.dynamicClassLoader = new DynamicClassLoader(this.parentClassLoader);
        }
        return this.dynamicClassLoader;
    }

    public DynamicCompiler addOption(String option) {
        this.options.add(option);
        return this;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setClassLoader(DynamicClassLoader dynamicClassLoader) {
        this.dynamicClassLoader = dynamicClassLoader;
    }

    public DynamicClassLoader newClassLoader() {
        return new DynamicClassLoader(this.parentClassLoader);
    }

    public StandardJavaFileManager getStandardFileManager() {
        return this.standardFileManager;
    }

    public DynamicCompiler addClassPath(File classPath) throws IOException {
        Iterable<? extends File> locations = this.standardFileManager.getLocation(StandardLocation.CLASS_PATH);
        List classpaths = StreamSupport.stream(locations.spliterator(), false).collect(Collectors.toList());
        classpaths.add(classPath);
        this.standardFileManager.setLocation(StandardLocation.CLASS_PATH, classpaths);
        return this;
    }

    public DynamicCompiler addSource(String className, String source) {
        this.addSource(new StringSource(className, source));
        return this;
    }

    public DynamicCompiler addSource(JavaFileObject javaFileObject) {
        this.compilationUnits.add(javaFileObject);
        return this;
    }

    public void reset() {
        this.dynamicClassLoader = null;
    }

    public void compile() {
        this.errors.clear();
        this.warnings.clear();
        DynamicJavaFileManager fileManager = new DynamicJavaFileManager(this.standardFileManager, this.getClassLoader());
        DiagnosticCollector collector = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.javaCompiler.getTask(null, fileManager, collector, this.options, null, this.compilationUnits);
        try {
            boolean result;
            if (!(this.compilationUnits.isEmpty() || (result = task.call().booleanValue()) && collector.getDiagnostics().size() <= 0)) {
                block8: for (Diagnostic diagnostic : collector.getDiagnostics()) {
                    switch (diagnostic.getKind()) {
                        case NOTE: 
                        case MANDATORY_WARNING: 
                        case WARNING: {
                            this.warnings.add(diagnostic);
                            continue block8;
                        }
                    }
                    this.errors.add(diagnostic);
                }
                if (!this.errors.isEmpty()) {
                    throw new DynamicCompilerException("Compilation Error", this.errors);
                }
            }
        }
        catch (Throwable e) {
            throw new DynamicCompilerException(e, this.errors);
        }
        finally {
            this.compilationUnits.clear();
        }
    }

    public void build() {
        this.compile();
        this.getClassLoader().prepareClasses();
    }

    private List<String> diagnosticToString(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        ArrayList<String> diagnosticMessages = new ArrayList<String>();
        for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
            diagnosticMessages.add("line: " + diagnostic.getLineNumber() + ", message: " + diagnostic.getMessage(Locale.US));
        }
        return diagnosticMessages;
    }

    public List<Diagnostic<? extends JavaFileObject>> getOriginalErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<Diagnostic<? extends JavaFileObject>> getOriginalWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public List<String> getErrors() {
        return this.diagnosticToString(this.errors);
    }

    public List<String> getWarnings() {
        return this.diagnosticToString(this.warnings);
    }
}

