/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.local.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.exception.CloudConfigException;
import org.noear.solon.cloud.extend.local.impl.CloudLocalUtils;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.service.CloudConfigService;

public class CloudConfigServiceLocalImpl
implements CloudConfigService {
    static final String DEFAULT_GROUP = "DEFAULT_GROUP";
    static final String CONFIG_KEY_FORMAT = "config/%s_%s";
    private final Map<String, Config> configMap = new HashMap<String, Config>();
    private final String server;
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();

    public CloudConfigServiceLocalImpl(CloudProps cloudProps) {
        this.server = cloudProps.getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config pull(String group, String name) {
        Config configVal;
        block6: {
            if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
                group = DEFAULT_GROUP;
            }
            String configKey = String.format(CONFIG_KEY_FORMAT, group, name);
            configVal = this.configMap.get(configKey);
            this.SYNC_LOCK.lock();
            try {
                if (configVal != null || (configVal = this.configMap.get(configKey)) != null) break block6;
                try {
                    String value2 = CloudLocalUtils.getValue(this.server, configKey);
                    configVal = new Config(group, name, value2, 0L);
                    this.configMap.put(configKey, configVal);
                }
                catch (IOException e) {
                    throw new CloudConfigException((Throwable)e);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        return configVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(String group, String name, String value) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = DEFAULT_GROUP;
        }
        String configKey = String.format(CONFIG_KEY_FORMAT, group, name);
        Config configVal = this.pull(group, name);
        this.SYNC_LOCK.lock();
        try {
            if (configVal == null) {
                configVal = new Config(group, name, value, 0L);
                this.configMap.put(configKey, configVal);
            }
            if (configVal != null) {
                configVal.updateValue(value, configVal.version() + 1L);
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
        return true;
    }

    public boolean remove(String group, String name) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = DEFAULT_GROUP;
        }
        String configKey = String.format(CONFIG_KEY_FORMAT, group, name);
        this.configMap.remove(configKey);
        return true;
    }

    public void attention(String group, String name, CloudConfigHandler observer) {
    }
}

