/*
 * Decompiled with CFR 0.152.
 */
package org.noear.mongox;

import java.io.IOException;
import java.util.Properties;
import org.noear.mongox.MgTableQuery;
import org.noear.mongox.MongoX;
import org.noear.wood.utils.StringUtils;

public class MgContext
implements AutoCloseable {
    private MongoX mongoX;

    public MgContext(Properties properties) {
        String schema = properties.getProperty("schema");
        if (StringUtils.isEmpty((String)schema)) {
            schema = properties.getProperty("db");
        }
        this.mongoX = new MongoX(properties, schema);
    }

    public MgContext(Properties properties, String schema) {
        this.mongoX = new MongoX(properties, schema);
    }

    public MgContext(String url, String schema) {
        this.mongoX = new MongoX(url, schema);
    }

    public MgTableQuery table(String table) {
        return new MgTableQuery(this.mongoX).table(table);
    }

    public MongoX mongo() {
        return this.mongoX;
    }

    @Override
    public void close() throws IOException {
        if (this.mongoX != null) {
            this.mongoX.close();
        }
    }
}

