/*
 * Decompiled with CFR 0.152.
 */
package org.noear.mongox;

import com.mongodb.client.FindIterable;
import com.mongodb.client.model.IndexOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.noear.mongox.MongoX;
import org.noear.wood.DataItem;
import org.noear.wood.cache.CacheUsing;
import org.noear.wood.cache.ICacheController;
import org.noear.wood.cache.ICacheService;
import org.noear.wood.ext.Fun2;

public class MgTableQuery
implements ICacheController<MgTableQuery> {
    private String table;
    private Map<String, Object> whereMap;
    private Map<String, Object> orderMap;
    private Map<String, Object> dataItem;
    private int limit_size;
    private int limit_start;
    private MongoX mongoX;
    protected CacheUsing _cache = null;

    private void initWhereMap() {
        if (this.whereMap == null) {
            this.whereMap = new LinkedHashMap<String, Object>();
        }
    }

    public MgTableQuery(MongoX mongoX) {
        this.mongoX = mongoX;
    }

    public MgTableQuery table(String table) {
        this.table = table;
        return this;
    }

    public MgTableQuery table(Class<?> table) {
        this.table = table.getSimpleName();
        return this;
    }

    public MgTableQuery whereMap(Map<String, Object> map) {
        this.whereMap = map;
        return this;
    }

    public MgTableQuery whereTrue() {
        this.initWhereMap();
        return this;
    }

    public MgTableQuery whereScript(String code) {
        this.initWhereMap();
        String fun = null;
        fun = code.contains("return ") ? "function (){" + code + "};" : "function (){return " + code + "};";
        this.whereMap.put("$where", fun);
        return this;
    }

    public MgTableQuery whereEq(String field, Object val) {
        this.initWhereMap();
        this.whereMap.put(field, val);
        return this;
    }

    public MgTableQuery whereNeq(String field, Object val) {
        this.initWhereMap();
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        tmp.put("$ne", val);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereLt(String field, Object val) {
        this.initWhereMap();
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        tmp.put("$lt", val);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereLte(String field, Object val) {
        this.initWhereMap();
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        tmp.put("$lte", val);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereGt(String field, Object val) {
        this.initWhereMap();
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        tmp.put("$gt", val);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereGte(String field, Object val) {
        this.initWhereMap();
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        tmp.put("$gte", val);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereBtw(String field, Object start, Object end) {
        this.initWhereMap();
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        tmp.put("$gte", start);
        tmp.put("$lte", end);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereNbtw(String field, Object start, Object end) {
        this.initWhereMap();
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        tmp.put("$gte", start);
        tmp.put("$lte", end);
        LinkedHashMap<String, LinkedHashMap<String, Object>> tmp2 = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        tmp2.put("$not", tmp);
        this.whereMap.put(field, tmp2);
        return this;
    }

    public MgTableQuery whereIn(String field, Iterable ary) {
        this.initWhereMap();
        LinkedHashMap<String, Iterable> tmp = new LinkedHashMap<String, Iterable>();
        tmp.put("$in", ary);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereNin(String field, Iterable ary) {
        this.initWhereMap();
        LinkedHashMap<String, Iterable> tmp = new LinkedHashMap<String, Iterable>();
        tmp.put("$nin", ary);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereLk(String field, String regex) {
        this.initWhereMap();
        Pattern pattern = Pattern.compile(regex, 2);
        this.whereMap.put(field, pattern);
        return this;
    }

    public MgTableQuery whereNlk(String field, String regex) {
        this.initWhereMap();
        Pattern expr = Pattern.compile(regex, 2);
        LinkedHashMap<String, Pattern> tmp = new LinkedHashMap<String, Pattern>();
        tmp.put("$not", expr);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereMod(String field, long base, long val) {
        this.initWhereMap();
        LinkedHashMap<String, List<Long>> tmp = new LinkedHashMap<String, List<Long>>();
        tmp.put("$mod", Arrays.asList(base, val));
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereNmod(String field, long base, long val) {
        this.initWhereMap();
        LinkedHashMap<String, List<Long>> tmp = new LinkedHashMap<String, List<Long>>();
        tmp.put("$mod", Arrays.asList(base, val));
        LinkedHashMap tmp2 = new LinkedHashMap();
        tmp2.put("$not", tmp2);
        this.whereMap.put(field, tmp2);
        return this;
    }

    public MgTableQuery whereAll(String field, Iterable ary) {
        this.initWhereMap();
        LinkedHashMap<String, Iterable> tmp = new LinkedHashMap<String, Iterable>();
        tmp.put("$all", ary);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereSize(String field, long size) {
        this.initWhereMap();
        LinkedHashMap<String, Long> tmp = new LinkedHashMap<String, Long>();
        tmp.put("$size", size);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery whereExists(String field, boolean exists) {
        this.initWhereMap();
        LinkedHashMap<String, Boolean> tmp = new LinkedHashMap<String, Boolean>();
        tmp.put("$exists", exists);
        this.whereMap.put(field, tmp);
        return this;
    }

    public MgTableQuery andEq(String field, Object val) {
        return this.whereEq(field, val);
    }

    public MgTableQuery andNeq(String field, Object val) {
        return this.whereNeq(field, val);
    }

    public MgTableQuery andLt(String field, Object val) {
        return this.whereLt(field, val);
    }

    public MgTableQuery andLte(String field, Object val) {
        return this.whereLte(field, val);
    }

    public MgTableQuery andGt(String field, Object val) {
        return this.whereGt(field, val);
    }

    public MgTableQuery andGte(String field, Object val) {
        return this.whereGte(field, val);
    }

    public MgTableQuery andBtw(String field, Object start, Object end) {
        return this.whereBtw(field, start, end);
    }

    public MgTableQuery andExists(String field, boolean exists) {
        return this.whereExists(field, exists);
    }

    public MgTableQuery andMod(String field, long base, long val) {
        return this.whereMod(field, base, val);
    }

    public MgTableQuery andNmod(String field, long base, long val) {
        return this.whereNmod(field, base, val);
    }

    public MgTableQuery andSize(String field, long size) {
        return this.whereSize(field, size);
    }

    public MgTableQuery andAll(String field, Iterable ary) {
        return this.whereAll(field, ary);
    }

    public MgTableQuery andIn(String field, Iterable ary) {
        return this.whereIn(field, ary);
    }

    public MgTableQuery andNin(String field, Iterable ary) {
        return this.whereNin(field, ary);
    }

    public MgTableQuery andLk(String field, String regex) {
        return this.whereLk(field, regex);
    }

    public MgTableQuery andNlk(String field, String regex) {
        return this.whereNlk(field, regex);
    }

    private Map<String, Object> buildFilter(boolean forced) {
        if (forced) {
            if (this.whereMap.size() == 0) {
                throw new IllegalArgumentException("No where condition...");
            }
        } else if (this.whereMap == null) {
            this.whereMap = new LinkedHashMap<String, Object>();
        }
        return this.whereMap;
    }

    public MgTableQuery set(String field, Object val) {
        if (this.dataItem == null) {
            this.dataItem = new LinkedHashMap<String, Object>();
        }
        this.dataItem.put(field, val);
        return this;
    }

    public MgTableQuery setInc(String field, long val) {
        if (this.dataItem == null) {
            this.dataItem = new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Long> tmp = new LinkedHashMap<String, Long>();
        tmp.put(field, val);
        this.dataItem.put("$inc", tmp);
        return this;
    }

    public MgTableQuery setMap(Map<String, Object> map) {
        this.dataItem = map;
        return this;
    }

    public MgTableQuery setMapIf(Map<String, Object> map, Fun2<Boolean, String, Object> condition) {
        this.dataItem = ((DataItem)new DataItem().setMapIf(map, condition)).getMap();
        return this;
    }

    public MgTableQuery setEntity(Object bean) {
        this.dataItem = ((DataItem)new DataItem().setEntity(bean)).getMap();
        return this;
    }

    public MgTableQuery setEntityIf(Object bean, Fun2<Boolean, String, Object> condition) {
        this.dataItem = ((DataItem)new DataItem().setEntityIf(bean, condition)).getMap();
        return this;
    }

    public void insert() {
        this.insert(this.dataItem);
    }

    public void insert(Map<String, Object> data) {
        if (data == null || data.size() == 0) {
            throw new IllegalArgumentException("No insert data...");
        }
        this.mongoX.insertOne(this.table, data);
    }

    public void insertList(List<Map<String, Object>> dataList) {
        this.mongoX.insertMany(this.table, dataList);
    }

    public long update() {
        if (this.dataItem == null || this.dataItem.size() == 0) {
            throw new IllegalArgumentException("No update data...");
        }
        Map<String, Object> filter = this.buildFilter(true);
        return this.mongoX.updateMany(this.table, filter, this.dataItem);
    }

    public long replace() {
        Map<String, Object> filter = this.buildFilter(true);
        return this.mongoX.replaceOne(this.table, filter, this.dataItem);
    }

    public long delete() {
        Map<String, Object> filter = this.buildFilter(true);
        return this.mongoX.deleteMany(this.table, filter);
    }

    public MgTableQuery limit(int size) {
        this.limit_size = size;
        return this;
    }

    public MgTableQuery limit(int start, int size) {
        this.limit_size = size;
        this.limit_start = start;
        return this;
    }

    public MgTableQuery orderByAsc(String field) {
        if (this.orderMap == null) {
            this.orderMap = new LinkedHashMap<String, Object>();
        }
        this.orderMap.put(field, 1);
        return this;
    }

    public MgTableQuery orderByDesc(String field) {
        if (this.orderMap == null) {
            this.orderMap = new LinkedHashMap<String, Object>();
        }
        this.orderMap.put(field, -1);
        return this;
    }

    public MgTableQuery andByAsc(String field) {
        return this.orderByAsc(field);
    }

    public MgTableQuery andByDesc(String field) {
        return this.orderByDesc(field);
    }

    public <T> List<T> selectList(Class<T> clz) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Document> listTmp = this.selectMapList();
        if (listTmp != null) {
            for (Map map : listTmp) {
                list.add(((DataItem)new DataItem().setMap(map)).toEntity(clz));
            }
        }
        return list;
    }

    public <T> T selectItem(Class<T> clz) {
        Document itemTmp = this.selectMap();
        if (itemTmp == null) {
            return null;
        }
        return (T)((DataItem)new DataItem().setMap((Map)itemTmp)).toEntity(clz);
    }

    private String getWoodkey(Map<String, Object> filter) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.table).append("@").append(filter.toString()).append("@").append(this.limit_size).append("@").append(this.limit_start);
        return buf.toString();
    }

    public List<Document> selectMapList() {
        Map<String, Object> filter = this.buildFilter(false);
        if (this._cache == null) {
            return this.selectMapListDo(filter);
        }
        String woodKey = this.getWoodkey(filter);
        return (List)this._cache.getEx(woodKey, () -> this.selectMapListDo(filter));
    }

    private List<Document> selectMapListDo(Map<String, Object> filter) {
        if (this.limit_size > 0) {
            return this.mongoX.findPage(this.table, filter, this.orderMap, this.limit_start, this.limit_size);
        }
        if (filter == null || filter.size() == 0) {
            throw new IllegalArgumentException("No where condition...");
        }
        return this.mongoX.findMany(this.table, filter, this.orderMap);
    }

    public <T> List<T> selectArray(String field) {
        ArrayList list = new ArrayList();
        List<Document> listTmp = this.selectMapList();
        if (listTmp != null) {
            for (Map map : listTmp) {
                Object v1 = map.get(field);
                if (v1 == null) continue;
                list.add(v1);
            }
        }
        return list;
    }

    public Document selectMap() {
        Map<String, Object> filter = this.buildFilter(true);
        if (this._cache == null) {
            return this.mongoX.findOne(this.table, filter);
        }
        String woodKey = this.getWoodkey(filter);
        return (Document)this._cache.getEx(woodKey, () -> this.mongoX.findOne(this.table, filter));
    }

    public long selectCount() {
        Map<String, Object> filter = this.buildFilter(false);
        if (this._cache == null) {
            return this.selectCountDo(filter);
        }
        String woodKey = this.getWoodkey(filter);
        return (Long)this._cache.getEx(woodKey, () -> this.selectCountDo(filter));
    }

    private long selectCountDo(Map<String, Object> filter) {
        if (filter.size() > 0) {
            return this.mongoX.countDocuments(this.table, filter);
        }
        return this.mongoX.count(this.table);
    }

    public boolean selectExists() {
        Document map = this.selectMap();
        return map != null && map.size() > 0;
    }

    public FindIterable<Document> selectCursor() {
        Map<String, Object> filter = this.buildFilter(true);
        FindIterable<Document> cursor = this.mongoX.find(this.table, filter);
        if (this.limit_size > 0) {
            if (this.limit_start > 0) {
                cursor.skip(this.limit_start);
            }
            cursor.limit(this.limit_size);
        }
        if (this.orderMap != null && this.orderMap.size() > 0) {
            cursor.sort((Bson)new Document(this.orderMap));
        }
        return cursor;
    }

    public String createIndex(boolean background) {
        return this.createIndex(new IndexOptions().background(background));
    }

    public String createIndex(Map<String, Object> options) {
        IndexOptions options1 = (IndexOptions)((DataItem)new DataItem().setMap(options)).toEntity(IndexOptions.class);
        return this.createIndex(options1);
    }

    public String createIndex(IndexOptions options) {
        if (this.orderMap == null || this.orderMap.size() == 0) {
            throw new IllegalArgumentException("No index keys...");
        }
        if (options == null) {
            return this.mongoX.createIndex(this.table, this.orderMap);
        }
        return this.mongoX.createIndex(this.table, this.orderMap, options);
    }

    public MgTableQuery build(Consumer<MgTableQuery> builder) {
        builder.accept(this);
        return this;
    }

    public MgTableQuery caching(ICacheService service) {
        this._cache = new CacheUsing(service);
        return this;
    }

    public MgTableQuery usingCache(boolean isCache) {
        this._cache.usingCache(isCache);
        return this;
    }

    public MgTableQuery usingCache(int seconds) {
        this._cache.usingCache(seconds);
        return this;
    }

    public MgTableQuery cacheTag(String tag) {
        this._cache.cacheTag(tag);
        return this;
    }
}

