/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.solon.plugins.pagination.dialects;

import com.baomidou.mybatisplus.solon.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.solon.plugins.pagination.dialects.IDialect;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SybaseDialect
implements IDialect {
    private final boolean hasTop;

    public SybaseDialect() {
        this(false);
    }

    public SybaseDialect(boolean hasTop) {
        this.hasTop = hasTop;
    }

    @Override
    public DialectModel buildPaginationSql(String originalSql, long offset, long limit) {
        int index = this.findMainFROM(originalSql);
        if (index == -1) {
            index = originalSql.toUpperCase().indexOf(" FROM ");
        }
        String sql = "select";
        if (this.hasTop) {
            sql = sql + " top " + (offset + limit);
        }
        sql = sql + " rownum=identity(12)," + originalSql.substring(6, index) + " into #t " + originalSql.substring(index);
        sql = sql + " select * from #t where rownum > ? and rownum <= ? ";
        sql = sql + "drop table #t ";
        return new DialectModel(sql, offset, offset + limit).setConsumerChain();
    }

    private int findMainFROM(String sql) {
        String tempSql = sql.toUpperCase();
        tempSql = tempSql.replace("\n", " ").replace("\t", " ").replace("\r", " ");
        Matcher select_ = Pattern.compile("SELECT ").matcher(tempSql);
        Matcher from_ = Pattern.compile(" FROM ").matcher(tempSql);
        ArrayList<Integer> selectIndex = new ArrayList<Integer>(10);
        ArrayList<Integer> fromIndex = new ArrayList<Integer>(10);
        while (select_.find()) {
            int start = select_.start();
            if (start != 0 && tempSql.charAt(start - 1) != ' ' && tempSql.charAt(start - 1) != '(') continue;
            selectIndex.add(start);
        }
        while (from_.find()) {
            fromIndex.add(from_.start());
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>(20);
        indexList.addAll(selectIndex);
        indexList.addAll(fromIndex);
        indexList.sort(Comparator.naturalOrder());
        if (indexList.size() < 2) {
            return -1;
        }
        int selectCount = 1;
        for (int i = 1; i < indexList.size(); ++i) {
            int each = (Integer)indexList.get(i);
            selectCount = fromIndex.contains(each) ? --selectCount : ++selectCount;
            if (selectCount != 0) continue;
            return each;
        }
        return -1;
    }
}

