/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.mybatis.integration;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ScanUtil;
import org.noear.solon.extend.mybatis.MybatisAdapter;
import org.noear.solon.extend.mybatis.integration.MybatisPluginManager;
import org.noear.solon.extend.mybatis.integration.MybatisPluginUtils;
import org.noear.solon.extend.mybatis.tran.SolonManagedTransactionFactory;

public class MybatisAdapterDefault
implements MybatisAdapter {
    protected final BeanWrap dsWrap;
    protected final Props dsProps;
    protected Configuration config;
    protected SqlSessionFactory factory;
    protected List<String> mappers = new ArrayList<String>();
    protected SqlSessionFactoryBuilder factoryBuilder;

    protected MybatisAdapterDefault(BeanWrap dsWrap) {
        this(dsWrap, Solon.cfg().getProp("mybatis"));
    }

    protected MybatisAdapterDefault(BeanWrap dsWrap, Props dsProps) {
        this.dsWrap = dsWrap;
        this.dsProps = dsProps == null ? new Props() : dsProps;
        this.factoryBuilder = new SqlSessionFactoryBuilder();
        DataSource dataSource = (DataSource)dsWrap.raw();
        String dataSourceId = "ds-" + (dsWrap.name() == null ? "" : dsWrap.name());
        SolonManagedTransactionFactory tf = new SolonManagedTransactionFactory();
        Environment environment = new Environment(dataSourceId, (TransactionFactory)tf, dataSource);
        this.initConfiguration(environment);
        for (Interceptor i : MybatisPluginManager.getInterceptors()) {
            this.config.addInterceptor(i);
        }
        dsWrap.context().beanOnloaded(ctx -> ctx.beanForeach(bw -> {
            if (bw.raw() instanceof Interceptor) {
                this.config.addInterceptor((Interceptor)bw.raw());
            }
        }));
        EventBus.push((Object)this.config);
        this.initDo();
        dsWrap.context().getWrapAsync(SqlSessionFactoryBuilder.class, bw -> {
            this.factoryBuilder = (SqlSessionFactoryBuilder)bw.raw();
        });
    }

    protected void initConfiguration(Environment environment) {
        this.config = new Configuration(environment);
        Props cfgProps = this.dsProps.getProp("configuration");
        if (cfgProps.size() > 0) {
            Utils.injectProperties((Object)this.config, (Properties)cfgProps);
        }
    }

    protected void initDo() {
        this.dsProps.forEach((k, v) -> {
            if (k instanceof String && v instanceof String) {
                Class clz;
                String key = (String)k;
                String valStr = (String)v;
                if (key.startsWith("typeAliases[") || key.equals("typeAliases")) {
                    for (String val : valStr.split(",")) {
                        if ((val = val.trim()).length() == 0) continue;
                        if (val.endsWith(".class")) {
                            clz = Utils.loadClass((String)val.substring(0, val.length() - 6));
                            if (clz == null) continue;
                            this.getConfiguration().getTypeAliasRegistry().registerAlias(clz);
                            continue;
                        }
                        this.getConfiguration().getTypeAliasRegistry().registerAliases(val);
                    }
                }
                if (key.startsWith("typeHandlers[") || key.equals("typeHandlers")) {
                    for (String val : valStr.split(",")) {
                        if ((val = val.trim()).length() == 0) continue;
                        if (val.endsWith(".class")) {
                            clz = Utils.loadClass((String)val.substring(0, val.length() - 6));
                            if (clz == null) continue;
                            this.getConfiguration().getTypeHandlerRegistry().register(clz);
                            continue;
                        }
                        this.getConfiguration().getTypeHandlerRegistry().register(val);
                    }
                }
            }
        });
        this.dsProps.forEach((k, v) -> {
            if (k instanceof String && v instanceof String) {
                String key = (String)k;
                String valStr = (String)v;
                if (key.startsWith("mappers[") || key.equals("mappers")) {
                    for (String val : valStr.split(",")) {
                        if ((val = val.trim()).length() == 0) continue;
                        if (val.endsWith(".xml")) {
                            if (val.contains("**")) {
                                Utils.resolvePaths((String)val).forEach(uri -> this.addMapperByXml((String)uri));
                            } else if (val.endsWith("*.xml")) {
                                String dir = val.substring(0, val.length() - 6);
                                ScanUtil.scan((String)dir, n -> n.endsWith(".xml")).forEach(uri -> this.addMapperByXml((String)uri));
                            } else {
                                this.addMapperByXml(val);
                            }
                            this.mappers.add(val);
                            continue;
                        }
                        if (val.endsWith(".class")) {
                            Class clz = Utils.loadClass((String)(val = val.replace("/", ".")).substring(0, val.length() - 6));
                            if (clz == null) continue;
                            this.getConfiguration().addMapper(clz);
                            this.mappers.add(val);
                            continue;
                        }
                        this.getConfiguration().addMappers(val);
                        this.mappers.add(val);
                    }
                }
            }
        });
        if (this.mappers.size() == 0) {
            throw new IllegalStateException("Please add the mappers configuration!");
        }
        if (this.config.getMapperRegistry().getMappers().size() == 0) {
            throw new IllegalStateException("Please check the mappers configuration!");
        }
        List<Interceptor> interceptors = MybatisPluginUtils.resolve(this.dsProps, "plugins");
        for (Interceptor itp : interceptors) {
            this.getConfiguration().addInterceptor(itp);
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public SqlSessionFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.factoryBuilder.build(this.getConfiguration());
        }
        return this.factory;
    }

    @Override
    public void injectTo(VarHolder varH) {
        if (MybatisAdapter.class.isAssignableFrom(varH.getType())) {
            varH.setValue((Object)this);
            return;
        }
        if (SqlSessionFactory.class.isAssignableFrom(varH.getType())) {
            varH.setValue((Object)this.getFactory());
            return;
        }
        if (Configuration.class.isAssignableFrom(varH.getType())) {
            varH.setValue((Object)this.getConfiguration());
            return;
        }
        if (varH.getType().isInterface()) {
            Object mapper = this.getMapper(varH.getType());
            varH.setValue(mapper);
            return;
        }
    }

    protected void addMapperByXml(String uri) {
        try {
            ErrorContext.instance().resource(uri);
            InputStream stream = Resources.getResourceAsStream((String)uri);
            XMLMapperBuilder mapperParser = new XMLMapperBuilder(stream, this.getConfiguration(), uri, this.getConfiguration().getSqlFragments());
            mapperParser.parse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

