/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.solon.integration;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.solon.MybatisAdapter;
import org.apache.ibatis.solon.MybatisAdapterFactory;
import org.apache.ibatis.solon.integration.MybatisAdapterDefault;
import org.apache.ibatis.solon.integration.MybatisAdapterFactoryDefault;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;

public class MybatisAdapterManager {
    private static MybatisAdapterFactory adapterFactory = new MybatisAdapterFactoryDefault();
    private static final Map<String, MybatisAdapter> dbMap = new ConcurrentHashMap<String, MybatisAdapter>();

    public static void setAdapterFactory(MybatisAdapterFactory adapterFactory) {
        MybatisAdapterManager.adapterFactory = adapterFactory;
    }

    public static MybatisAdapter getOnly(String name) {
        return dbMap.get(name);
    }

    public static Map<String, MybatisAdapter> getAll() {
        return Collections.unmodifiableMap(dbMap);
    }

    public static MybatisAdapter get(BeanWrap bw) {
        MybatisAdapter db = dbMap.get(bw.name());
        if (db == null) {
            Utils.locker().lock();
            try {
                db = dbMap.get(bw.name());
                if (db == null) {
                    db = MybatisAdapterManager.buildAdapter(bw);
                    MybatisAdapterManager.register(bw, db);
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return db;
    }

    public static void register(BeanWrap bw, MybatisAdapter adapter) {
        dbMap.put(bw.name(), adapter);
        if (bw.typed()) {
            dbMap.put("", adapter);
        }
    }

    public static void register(BeanWrap bw) {
        MybatisAdapterManager.get(bw);
    }

    private static MybatisAdapter buildAdapter(BeanWrap bw) {
        MybatisAdapter tmp = Utils.isEmpty((String)bw.name()) ? adapterFactory.create(bw) : adapterFactory.create(bw, bw.context().cfg().getProp("mybatis." + bw.name()));
        if (tmp instanceof MybatisAdapterDefault) {
            ((MybatisAdapterDefault)tmp).mapperPublish();
        }
        return tmp;
    }
}

