/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.solon.integration;

import com.jn.sqlhelper.mybatis.MybatisUtils;
import com.jn.sqlhelper.mybatis.plugins.CustomScriptLanguageDriver;
import com.jn.sqlhelper.mybatis.plugins.SqlHelperMybatisPlugin;
import com.jn.sqlhelper.mybatis.solon.integration.SqlHelperSupplier;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.core.event.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration
public class SqlHelperConfiguration
implements EventListener<org.apache.ibatis.session.Configuration> {
    private static final Logger log = LoggerFactory.getLogger(SqlHelperConfiguration.class);
    private SqlHelperSupplier sqlHelperSupplier = new SqlHelperSupplier();

    @Bean
    public DatabaseIdProvider databaseIdProvider() {
        return MybatisUtils.vendorDatabaseIdProvider();
    }

    @Bean
    public LanguageDriver customScriptLanguageDriver() {
        return new CustomScriptLanguageDriver();
    }

    public void onEvent(org.apache.ibatis.session.Configuration configuration) {
        if (this.sqlHelperSupplier.get() == null) {
            return;
        }
        log.info("Mybatis: Start to customize mybatis configuration with mybatis-sqlhelper-solon-plugin");
        configuration.setDefaultScriptingLanguage(CustomScriptLanguageDriver.class);
        log.info("Mybatis: The interceptor has been added: " + SqlHelperMybatisPlugin.class);
        configuration.addInterceptor((Interceptor)this.sqlHelperSupplier.get());
    }
}

