/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.mybatis.solon.integration;

import com.jn.sqlhelper.dialect.instrument.SQLInstrumentorConfig;
import com.jn.sqlhelper.mybatis.plugins.SqlHelperMybatisPlugin;
import com.jn.sqlhelper.mybatis.plugins.pagination.PaginationConfig;
import java.util.function.Supplier;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.Props;

public class SqlHelperSupplier
implements Supplier<SqlHelperMybatisPlugin> {
    private final SQLInstrumentorConfig sqlInstrumentConfig;
    private final PaginationConfig paginationPluginConfig;
    private SqlHelperMybatisPlugin pageInterceptor;

    public SqlHelperSupplier() {
        this(null);
    }

    public SqlHelperSupplier(String propStarts) {
        if (Utils.isEmpty((String)propStarts)) {
            propStarts = "sqlhelper.mybatis";
        }
        Props props = Solon.cfg().getProp(propStarts);
        this.paginationPluginConfig = (PaginationConfig)props.toBean("pagination", PaginationConfig.class);
        this.sqlInstrumentConfig = (SQLInstrumentorConfig)props.toBean("instrumentor", SQLInstrumentorConfig.class);
    }

    public PaginationConfig paginationConfig() {
        return this.paginationPluginConfig;
    }

    public SQLInstrumentorConfig instrumentConfig() {
        return this.sqlInstrumentConfig;
    }

    @Override
    public SqlHelperMybatisPlugin get() {
        if (this.paginationPluginConfig == null || this.sqlInstrumentConfig == null) {
            return null;
        }
        if (this.pageInterceptor == null) {
            this.pageInterceptor = new SqlHelperMybatisPlugin();
            this.pageInterceptor.setPaginationConfig(this.paginationPluginConfig);
            this.pageInterceptor.setInstrumentorConfig(this.sqlInstrumentConfig);
            this.pageInterceptor.init();
        }
        return this.pageInterceptor;
    }
}

