/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.nacos.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.http.util.TextUtils;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.nacos.impl.InstanceWrap;
import org.noear.solon.cloud.extend.nacos.impl.NacosConfig;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;

public class CloudDiscoveryServiceNacosImp
implements CloudDiscoveryService {
    private NamingService real;
    private boolean unstable;
    private String clusterName;

    public CloudDiscoveryServiceNacosImp(CloudProps cloudProps) {
        Properties properties = NacosConfig.getServiceProperties(cloudProps, (Properties)cloudProps.getProp("discovery"), cloudProps.getDiscoveryServer());
        this.unstable = true;
        this.clusterName = cloudProps.getDiscoveryClusterName();
        if (Utils.isEmpty((String)this.clusterName)) {
            this.clusterName = "DEFAULT";
        }
        try {
            this.real = NamingFactory.createNamingService((Properties)properties);
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void register(String group, Instance instance) {
        this.registerState(group, instance, true);
    }

    public void registerState(String group, Instance instance, boolean health) {
        String[] ss;
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        if ((ss = instance.address().split(":")).length != 2) {
            throw new IllegalArgumentException("Instance.address error");
        }
        InstanceWrap iw = new InstanceWrap();
        iw.setIp(ss[0]);
        iw.setPort(Integer.parseInt(ss[1]));
        iw.setClusterName(this.clusterName);
        iw.setMetadata(instance.meta());
        iw.setHealthy(health);
        iw.setEphemeral(this.unstable);
        iw.setWeight(1.0);
        iw.setEnabled(Solon.cfg().appEnabled());
        try {
            if (Utils.isEmpty((String)group)) {
                this.real.registerInstance(instance.service(), (com.alibaba.nacos.api.naming.pojo.Instance)iw);
            } else {
                this.real.registerInstance(instance.service(), group, (com.alibaba.nacos.api.naming.pojo.Instance)iw);
            }
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void deregister(String group, Instance instance) {
        String[] ss;
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        if ((ss = instance.address().split(":")).length != 2) {
            throw new IllegalArgumentException("Instance.address error");
        }
        InstanceWrap iw = new InstanceWrap();
        iw.setIp(ss[0]);
        iw.setPort(Integer.parseInt(ss[1]));
        iw.setClusterName(this.clusterName);
        iw.setMetadata(instance.meta());
        iw.setHealthy(false);
        iw.setEphemeral(this.unstable);
        iw.setWeight(1.0);
        try {
            if (Utils.isEmpty((String)group)) {
                this.real.deregisterInstance(instance.service(), (com.alibaba.nacos.api.naming.pojo.Instance)iw);
            } else {
                this.real.deregisterInstance(instance.service(), group, (com.alibaba.nacos.api.naming.pojo.Instance)iw);
            }
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Discovery find(String group, String service) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        Discovery discovery = new Discovery(group, service);
        try {
            List list = null;
            list = Utils.isEmpty((String)group) ? this.real.selectInstances(service, true) : this.real.selectInstances(service, group, true);
            for (com.alibaba.nacos.api.naming.pojo.Instance i1 : list) {
                Instance n1 = new Instance(service, i1.getIp(), i1.getPort()).weight(i1.getWeight()).metaPutAll(i1.getMetadata());
                n1.metaPut("clusterName", i1.getClusterName());
                discovery.instanceAdd(n1);
            }
            return discovery;
        }
        catch (NacosException ex) {
            throw new RuntimeException();
        }
    }

    public Collection<String> findServices(String group) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        try {
            return this.real.getServicesOfServer(1, Integer.MAX_VALUE, group).getData();
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        CloudDiscoveryObserverEntity entity = new CloudDiscoveryObserverEntity(group, service, observer);
        try {
            if (TextUtils.isEmpty((CharSequence)group)) {
                this.real.subscribe(service, event -> {
                    Discovery discovery = this.find(entity.group, service);
                    entity.handle(discovery);
                });
            } else {
                this.real.subscribe(service, group, event -> {
                    Discovery discovery = this.find(entity.group, service);
                    entity.handle(discovery);
                });
            }
        }
        catch (NacosException ex) {
            throw new RuntimeException();
        }
    }
}

