/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.polaris.service;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.configuration.api.core.ConfigFile;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.factory.ConfigFileServiceFactory;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.configuration.ConnectorConfigImpl;
import com.tencent.polaris.factory.config.global.ClusterConfigImpl;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.exception.CloudConfigException;
import org.noear.solon.cloud.extend.polaris.PolarisProps;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.service.CloudConfigObserverEntity;
import org.noear.solon.cloud.service.CloudConfigService;

public class CloudConfigServicePolarisImp
implements CloudConfigService,
Closeable {
    private final CloudProps cloudProps;
    private ConfigFileService real;

    public CloudConfigServicePolarisImp(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        String server = cloudProps.getConfigServer();
        String namespace = cloudProps.getNamespace();
        ConfigurationImpl cfgImpl = PolarisProps.getCfgImpl();
        ClusterConfigImpl clusterConfig = cfgImpl.getGlobal().getSystem().getConfigCluster();
        clusterConfig.setNamespace(namespace);
        ConnectorConfigImpl connectorConfig = cfgImpl.getConfigFile().getServerConnector();
        List address = connectorConfig.getAddresses();
        address.add(server);
        connectorConfig.setAddresses(address);
        this.real = ConfigFileServiceFactory.createConfigFileService((Configuration)cfgImpl);
    }

    public Config pull(String group, String name) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        ConfigFile configFile = this.real.getConfigFile(this.cloudProps.getNamespace(), group, name);
        return new Config(group, name, configFile.getContent(), 0L);
    }

    public boolean push(String group, String name, String value) {
        throw new CloudConfigException("Polaris does not support config push");
    }

    public boolean remove(String group, String name) {
        throw new CloudConfigException("Polaris does not support config remove");
    }

    public void attention(String group, String name, CloudConfigHandler observer) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        CloudConfigObserverEntity entity = new CloudConfigObserverEntity(group, name, observer);
        ConfigFile configFile = this.real.getConfigFile(this.cloudProps.getNamespace(), group, name);
        configFile.addChangeListener(event -> entity.handle(new Config(entity.group, entity.key, event.getNewValue(), System.currentTimeMillis())));
    }

    @Override
    public void close() throws IOException {
    }
}

