/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.polaris.service;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.rpc.GetHealthyInstancesRequest;
import com.tencent.polaris.api.rpc.GetServicesRequest;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.ServicesResponse;
import com.tencent.polaris.api.rpc.WatchServiceRequest;
import com.tencent.polaris.factory.api.DiscoveryAPIFactory;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.global.ClusterConfigImpl;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.polaris.PolarisProps;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;

public class CloudDiscoveryServicePolarisImp
implements CloudDiscoveryService,
Closeable {
    private final CloudProps cloudProps;
    private ProviderAPI providerAPI;
    private ConsumerAPI consumerAPI;

    public CloudDiscoveryServicePolarisImp(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        String server = cloudProps.getDiscoveryServer();
        ConfigurationImpl cfgImpl = PolarisProps.getCfgImpl();
        ClusterConfigImpl clusterConfig = cfgImpl.getGlobal().getSystem().getDiscoverCluster();
        clusterConfig.setNamespace(cloudProps.getNamespace());
        ServerConnectorConfigImpl connectorConfig = cfgImpl.getGlobal().getServerConnector();
        List address = connectorConfig.getAddresses();
        address.add(server);
        connectorConfig.setAddresses(address);
        this.providerAPI = DiscoveryAPIFactory.createProviderAPIByConfig((Configuration)cfgImpl);
        this.consumerAPI = DiscoveryAPIFactory.createConsumerAPIByConfig((Configuration)cfgImpl);
    }

    public void register(String group, org.noear.solon.cloud.model.Instance instance) {
        if (!Solon.cfg().appEnabled()) {
            return;
        }
        this.registerState(group, instance, true);
    }

    public void registerState(String group, org.noear.solon.cloud.model.Instance instance, boolean health) {
        String[] ss = instance.address().split(":");
        if (ss.length != 2) {
            throw new IllegalArgumentException("Instance.address error");
        }
        InstanceRegisterRequest request = new InstanceRegisterRequest();
        request.setNamespace(this.cloudProps.getNamespace());
        request.setWeight(Integer.valueOf((int)instance.weight()));
        request.setMetadata(instance.meta());
        request.setService(instance.service());
        request.setHost(ss[0]);
        request.setPort(Integer.valueOf(Integer.parseInt(ss[1])));
        request.setProtocol(instance.protocol());
        this.providerAPI.registerInstance(request);
    }

    public void deregister(String group, org.noear.solon.cloud.model.Instance instance) {
        String[] ss = instance.address().split(":");
        if (ss.length != 2) {
            throw new IllegalArgumentException("Instance.address error");
        }
        InstanceDeregisterRequest deregisterRequest = new InstanceDeregisterRequest();
        deregisterRequest.setNamespace(this.cloudProps.getNamespace());
        deregisterRequest.setService(instance.service());
        deregisterRequest.setHost(ss[0]);
        deregisterRequest.setPort(Integer.valueOf(Integer.parseInt(ss[1])));
        this.providerAPI.deRegister(deregisterRequest);
    }

    public Discovery find(String group, String service) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        Discovery discovery = new Discovery(group, service);
        GetHealthyInstancesRequest request = new GetHealthyInstancesRequest();
        request.setNamespace(this.cloudProps.getNamespace());
        request.setService(service);
        InstancesResponse instancesResponse = this.consumerAPI.getHealthyInstances(request);
        if (Objects.isNull(instancesResponse) || instancesResponse.getInstances().length > 0) {
            return discovery;
        }
        for (Instance instance : instancesResponse.getInstances()) {
            if (!instance.isHealthy()) continue;
            discovery.instanceAdd(new org.noear.solon.cloud.model.Instance(service, instance.getHost(), instance.getPort()).weight((double)instance.getWeight()).protocol(instance.getProtocol()).metaPutAll(instance.getMetadata()));
        }
        return discovery;
    }

    public Collection<String> findServices(String group) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        GetServicesRequest request = new GetServicesRequest();
        request.setNamespace(this.cloudProps.getNamespace());
        ServicesResponse response = this.consumerAPI.getServices(request);
        HashSet<String> serviceNames = new HashSet<String>();
        for (ServiceInfo s1 : response.getServices()) {
            serviceNames.add(s1.getService());
        }
        return serviceNames;
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        CloudDiscoveryObserverEntity entity = new CloudDiscoveryObserverEntity(group, service, observer);
        WatchServiceRequest request = WatchServiceRequest.builder().namespace(this.cloudProps.getNamespace()).service(service).listeners(Collections.singletonList(event -> {
            Discovery discovery = new Discovery(entity.group, service);
            for (Instance instance : event.getAllInstances()) {
                if (!instance.isHealthy()) continue;
                discovery.instanceAdd(new org.noear.solon.cloud.model.Instance(service, instance.getHost(), instance.getPort()).weight((double)instance.getWeight()).protocol(instance.getProtocol()).metaPutAll(instance.getMetadata()));
            }
            entity.handle(discovery);
        })).build();
        this.consumerAPI.watchService(request);
    }

    @Override
    public void close() throws IOException {
        if (this.consumerAPI != null) {
            this.consumerAPI.close();
        }
        if (this.providerAPI != null) {
            this.providerAPI.close();
        }
    }
}

