/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.quartz;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.extend.quartz.AbstractJob;
import org.noear.solon.extend.quartz.JobHolder;
import org.noear.solon.extend.quartz.QuartzProxy;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public final class JobManager {
    static Scheduler _scheduler = null;
    static Map<String, JobHolder> jobMap = new HashMap<String, JobHolder>();

    public static void setScheduler(Scheduler scheduler) {
        if (_scheduler == null) {
            _scheduler = scheduler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void tryInitScheduler() throws SchedulerException {
        if (_scheduler != null) return;
        Class<JobManager> clazz = JobManager.class;
        synchronized (JobManager.class) {
            if (_scheduler != null) return;
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            _scheduler = schedulerFactory.getScheduler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void start() throws SchedulerException {
        JobManager.tryInitScheduler();
        for (JobHolder jobEntity : jobMap.values()) {
            JobManager.regJob(jobEntity);
        }
        if (_scheduler != null) {
            _scheduler.start();
        }
    }

    public static void stop() throws SchedulerException {
        if (_scheduler != null) {
            _scheduler.shutdown();
            _scheduler = null;
        }
    }

    public static void addJob(String name, String cronx, boolean enable, AbstractJob job) throws Exception {
        if (!enable) {
            return;
        }
        if (Utils.isEmpty((String)name)) {
            throw new IllegalArgumentException("The job name cannot be empty!");
        }
        if (!jobMap.containsKey(name)) {
            JobHolder jobEntity = new JobHolder(name, cronx, enable, job);
            jobMap.put(name, jobEntity);
        }
    }

    public static JobHolder getJob(String name) {
        if (Utils.isEmpty((String)name)) {
            return null;
        }
        return jobMap.get(name);
    }

    private static void regJob(JobHolder jobEntity) throws SchedulerException {
        String jobGroup = Utils.annoAlias((String)Solon.cfg().appName(), (String)"solon");
        if (jobEntity.cronx.indexOf(" ") < 0) {
            if (jobEntity.cronx.endsWith("ms")) {
                long period = Long.parseLong(jobEntity.cronx.substring(0, jobEntity.cronx.length() - 2));
                JobManager.regJobByPeriod(jobEntity, period, TimeUnit.MILLISECONDS, jobGroup);
            } else if (jobEntity.cronx.endsWith("s")) {
                long period = Long.parseLong(jobEntity.cronx.substring(0, jobEntity.cronx.length() - 1));
                JobManager.regJobByPeriod(jobEntity, period, TimeUnit.SECONDS, jobGroup);
            } else if (jobEntity.cronx.endsWith("m")) {
                long period = Long.parseLong(jobEntity.cronx.substring(0, jobEntity.cronx.length() - 1));
                JobManager.regJobByPeriod(jobEntity, period, TimeUnit.MINUTES, jobGroup);
            } else if (jobEntity.cronx.endsWith("h")) {
                long period = Long.parseLong(jobEntity.cronx.substring(0, jobEntity.cronx.length() - 1));
                JobManager.regJobByPeriod(jobEntity, period, TimeUnit.HOURS, jobGroup);
            } else if (jobEntity.cronx.endsWith("d")) {
                long period = Long.parseLong(jobEntity.cronx.substring(0, jobEntity.cronx.length() - 1));
                JobManager.regJobByPeriod(jobEntity, period, TimeUnit.DAYS, jobGroup);
            }
        } else {
            JobManager.regJobByCron(jobEntity, jobEntity.cronx, jobGroup);
        }
    }

    private static void regJobByCron(JobHolder jobEntity, String cron, String jobGroup) throws SchedulerException {
        JobManager.tryInitScheduler();
        JobDetail jobDetail = JobBuilder.newJob(QuartzProxy.class).withIdentity(jobEntity.name, jobGroup).build();
        if (!_scheduler.checkExists(jobDetail.getKey())) {
            CronScheduleBuilder builder = CronScheduleBuilder.cronSchedule((String)cron);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobEntity.name, jobGroup).startNow().withSchedule((ScheduleBuilder)builder).build();
            _scheduler.scheduleJob(jobDetail, trigger);
        }
    }

    private static void regJobByPeriod(JobHolder jobEntity, long period, TimeUnit unit, String jobGroup) throws SchedulerException {
        JobManager.tryInitScheduler();
        JobDetail jobDetail = JobBuilder.newJob(QuartzProxy.class).withIdentity(jobEntity.name, jobGroup).build();
        if (!_scheduler.checkExists(jobDetail.getKey())) {
            SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule();
            switch (unit) {
                case MILLISECONDS: {
                    builder.withIntervalInMilliseconds(period);
                    break;
                }
                case SECONDS: {
                    builder.withIntervalInSeconds((int)period);
                    break;
                }
                case MINUTES: {
                    builder.withIntervalInMinutes((int)period);
                    break;
                }
                case HOURS: {
                    builder.withIntervalInHours((int)period);
                    break;
                }
                case DAYS: {
                    builder.withIntervalInHours((int)(period * 24L));
                    break;
                }
                default: {
                    return;
                }
            }
            builder.repeatForever();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobEntity.name, jobGroup).startNow().withSchedule((ScheduleBuilder)builder).build();
            _scheduler.scheduleJob(jobDetail, trigger);
        }
    }
}

