/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.quartz.integration;

import java.lang.reflect.Method;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.extend.quartz.AbstractJob;
import org.noear.solon.extend.quartz.JobManager;
import org.noear.solon.extend.quartz.Quartz;
import org.noear.solon.extend.quartz.integration.BeanJob;
import org.noear.solon.extend.quartz.integration.MethodJob;
import org.quartz.Job;
import org.quartz.JobExecutionContext;

public class QuartzBeanBuilder
implements BeanBuilder<Quartz>,
BeanExtractor<Quartz> {
    public void doBuild(Class<?> clz, BeanWrap bw, Quartz anno) throws Throwable {
        Props prop;
        if (!(bw.raw() instanceof Job) && !(bw.raw() instanceof Runnable)) {
            throw new IllegalStateException("Quartz job only supports Runnable or Job types!");
        }
        String cronx = anno.cron7x();
        String nameOfAnno = anno.name();
        boolean enable = anno.enable();
        if (Utils.isNotEmpty((String)nameOfAnno) && (prop = Solon.cfg().getProp("solon.quartz." + nameOfAnno)).size() > 0) {
            String cronxTmp = prop.getProperty("cron7x");
            String enableTmp = prop.getProperty("enable");
            if ("false".equals(enableTmp)) {
                enable = false;
            }
            if (Utils.isNotEmpty((String)cronxTmp)) {
                cronx = cronxTmp;
            }
        }
        BeanJob job = new BeanJob(bw.raw());
        String name = Utils.annoAlias((String)nameOfAnno, (String)((AbstractJob)job).getJobId());
        JobManager.addJob(name, cronx, enable, job);
    }

    public void doExtract(BeanWrap bw, Method method, Quartz anno) throws Throwable {
        Props prop;
        Class<?> tmp;
        if (method.getParameterCount() > 1) {
            throw new IllegalStateException("Quartz job supports only one JobExecutionContext parameter!");
        }
        if (method.getParameterCount() == 1 && (tmp = method.getParameterTypes()[0]) != JobExecutionContext.class) {
            throw new IllegalStateException("Quartz job supports only one JobExecutionContext parameter!");
        }
        String cronx = anno.cron7x();
        String nameOfAnno = anno.name();
        boolean enable = anno.enable();
        if (Utils.isNotEmpty((String)nameOfAnno) && (prop = Solon.cfg().getProp("solon.quartz." + nameOfAnno)).size() > 0) {
            String cronxTmp = prop.getProperty("cron7x");
            String enableTmp = prop.getProperty("enable");
            if ("false".equals(enableTmp)) {
                enable = false;
            }
            if (Utils.isNotEmpty((String)cronxTmp)) {
                cronx = cronxTmp;
            }
        }
        MethodJob job = new MethodJob(bw.raw(), method);
        String name = Utils.annoAlias((String)nameOfAnno, (String)((AbstractJob)job).getJobId());
        JobManager.addJob(name, cronx, enable, job);
    }
}

