/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.impl;

import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConfig;

public class RabbitChannelFactory {
    private ConnectionFactory connectionFactory;
    private RabbitConfig config;
    private Connection connection;

    public RabbitChannelFactory(RabbitConfig config) throws IOException, TimeoutException {
        this.config = config;
        String host = config.server.split(":")[0];
        int port = Integer.parseInt(config.server.split(":")[1]);
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(host);
        this.connectionFactory.setPort(port);
        this.connectionFactory.setRequestedHeartbeat(30);
        if (Utils.isNotEmpty((String)config.username)) {
            this.connectionFactory.setUsername(config.username);
        }
        if (Utils.isNotEmpty((String)config.password)) {
            this.connectionFactory.setPassword(config.password);
        }
        if (Utils.isNotEmpty((String)config.virtualHost)) {
            this.connectionFactory.setVirtualHost(config.virtualHost);
        }
        this.connectionFactory.setAutomaticRecoveryEnabled(true);
        this.connectionFactory.setNetworkRecoveryInterval(5000L);
        this.connection = this.connectionFactory.newConnection();
    }

    public Channel createChannel(boolean forTran) throws IOException, TimeoutException {
        Channel channel = this.connection.createChannel();
        return this.initChannel(channel, forTran);
    }

    private Channel initChannel(Channel channel, boolean forTran) throws IOException {
        String string = this.config.exchangeName;
        BuiltinExchangeType builtinExchangeType = this.config.exchangeType;
        boolean bl = this.config.durable;
        this.config.getClass();
        this.config.getClass();
        channel.exchangeDeclare(string, builtinExchangeType, bl, false, false, new HashMap());
        if (this.config.publishTimeout > 0L && !forTran) {
            channel.confirmSelect();
        }
        channel.basicQos(this.config.prefetchCount);
        return channel;
    }
}

